/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.index;

import java.util.ArrayList;
import java.util.Objects;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.StringToken;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Union;
import org.basex.query.expr.index.IndexAccess;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.expr.path.NameTest;
import org.basex.query.func.Function;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.DBNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class ValueAccess
extends IndexAccess {
    private Expr expr;
    private final IndexType type;
    private final NameTest test;
    private boolean trim;

    public ValueAccess(InputInfo info, Expr expr, IndexType type, NameTest test, IndexDb db) {
        super(db, info, type);
        this.expr = expr;
        this.type = type;
        this.test = test;
    }

    public ValueAccess trim(boolean tr) {
        this.trim = tr;
        return this;
    }

    @Override
    public BasicNodeIter iter(QueryContext qc) throws QueryException {
        Item item;
        Data data = this.db.data(qc, this.type);
        if (this.expr.seqType().zeroOrOne()) {
            return this.iter(this.expr.item(qc, this.info), data);
        }
        ArrayList<BasicNodeIter> iters = new ArrayList<BasicNodeIter>();
        Iter iter = this.expr.iter(qc);
        while ((item = qc.next(iter)) != null) {
            iters.add(this.iter(item, data));
        }
        int is = iters.size();
        return is == 0 ? BasicNodeIter.EMPTY : (is == 1 ? (BasicNodeIter)iters.get(0) : new Union(this.info, this.expr).eval(iters.toArray(new NodeIter[is]), qc).iter());
    }

    private BasicNodeIter iter(Item item, Data data) throws QueryException {
        if (item == null) {
            return BasicNodeIter.EMPTY;
        }
        byte[] token = item.string(this.info);
        byte[] term = this.trim ? Token.trim(token) : token;
        int tl = term.length;
        if (tl == 0 && this.type == IndexType.TEXT) {
            return this.test == null ? BasicNodeIter.EMPTY : this.scanEmpty(data);
        }
        boolean index = data.meta.index(this.type);
        if (this.type == IndexType.TEXT || this.type == IndexType.ATTRIBUTE) {
            index &= tl > 0 && tl <= data.meta.maxlen;
        }
        final IndexIterator ii = index ? data.iter(new StringToken(this.type, term)) : this.scan(term, data);
        final int kind = this.type == IndexType.TEXT ? 2 : 3;
        final DBNode tmp = new DBNode(data, 0, this.test == null ? kind : 1);
        return new DBNodeIter(data){

            @Override
            public DBNode next() {
                while (ii.more()) {
                    if (ValueAccess.this.test == null) {
                        tmp.pre(ii.pre());
                    } else {
                        tmp.pre(this.data.parent(ii.pre(), kind));
                        if (!ValueAccess.this.test.eq(tmp)) continue;
                    }
                    return tmp.finish();
                }
                return null;
            }
        };
    }

    private IndexIterator scan(final byte[] value, final Data data) {
        return new IndexIterator(){
            final boolean text;
            final byte kind;
            final int sz;
            int pre;
            {
                this.text = ValueAccess.this.type == IndexType.TEXT;
                this.kind = (byte)(this.text ? 2 : 3);
                this.sz = data.meta.size;
                this.pre = -1;
            }

            @Override
            public int pre() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < this.sz) {
                    if (data.kind(this.pre) != this.kind || !Token.eq(data.text(this.pre, this.text), value)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                return Math.max(1, this.sz >>> 1);
            }
        };
    }

    private BasicNodeIter scanEmpty(Data data) {
        return new DBNodeIter(data){
            final DBNode tmp;
            final int sz;
            int pre;
            {
                this.tmp = new DBNode(this.data, 0, 1);
                this.sz = this.data.meta.size;
                this.pre = -1;
            }

            @Override
            public DBNode next() {
                while (++this.pre < this.sz) {
                    if (this.data.kind(this.pre) != 1 || this.data.size(this.pre, 1) != 1) continue;
                    this.tmp.pre(this.pre);
                    if (ValueAccess.this.test != null && !ValueAccess.this.test.eq(this.tmp)) continue;
                    return this.tmp.finish();
                }
                return null;
            }
        };
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.expr.has(flags) && super.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        return this.expr.removable(var) && super.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.expr.count(var).plus(super.count(var));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        Expr sub = this.expr.inline(var, ex, cc);
        if (sub != null) {
            this.expr = sub;
        }
        Expr ia = super.inline(var, ex, cc);
        return sub != null || ia != null ? this.optimize(cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new ValueAccess(this.info, this.expr.copy(cc, vm), this.type, this.test, (IndexDb)this.db.copy(cc, (IntObjMap)vm)));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize() + super.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ValueAccess)) {
            return false;
        }
        ValueAccess v = (ValueAccess)obj;
        return this.expr.equals(obj) && this.type == v.type && Objects.equals(this.test, v.test) && this.trim == v.trim && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        ValueAccess.addPlan(plan, this.planElem(new Object[]{"index", this.type, "name", this.test}), this.db, this.expr);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        Function func = this.type == IndexType.TEXT ? Function._DB_TEXT : (this.type == IndexType.ATTRIBUTE ? Function._DB_ATTRIBUTE : Function._DB_TOKEN);
        tb.add(func.args(this.db.source(), this.expr).substring(1));
        if (this.test != null) {
            tb.add("/parent::").addExt(this.test, new Object[0]);
        }
        return tb.toString();
    }
}

