/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.index;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.NodeType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class IndexDynDb
extends IndexDb {
    private Expr expr;

    public IndexDynDb(InputInfo info, boolean iterable, Expr expr) {
        super(info, iterable);
        this.expr = expr;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.expr);
    }

    @Override
    public Expr compile(CompileContext cc) {
        return this;
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.expr.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        return this.expr.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.expr.count(var);
    }

    @Override
    public IndexDb inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        Expr sub = this.expr.inline(var, ex, cc);
        if (sub == null) {
            return null;
        }
        this.expr = sub;
        return this;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize() + 1;
    }

    @Override
    public IndexDynDb copy(CompileContext cc, IntObjMap<Var> vm) {
        return new IndexDynDb(this.info, this.iterable, this.expr.copy(cc, vm));
    }

    @Override
    public Data data(QueryContext qc, IndexType type) throws QueryException {
        Value value = this.expr.value(qc);
        Data data = value.data();
        if (data == null || !value.seqType().type.instanceOf(NodeType.DOC)) {
            throw QueryError.DB_NODE_X.get(this.info, value);
        }
        type.check(data, this.info);
        return data;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof IndexDynDb && this.expr.equals(((IndexDynDb)obj).expr) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        IndexDynDb.addPlan(plan, this.planElem(new Object[0]), this.expr);
    }

    @Override
    public Expr source() {
        return this.expr;
    }
}

