/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.Objects;
import org.basex.query.CompileContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class OrderKey
extends Single {
    final boolean desc;
    final boolean least;
    final Collation coll;

    public OrderKey(InputInfo info, Expr key, boolean desc, boolean least, Collation coll) {
        super(info, key, SeqType.ITEM_ZM);
        this.desc = desc;
        this.least = least;
        this.coll = coll;
    }

    @Override
    public OrderKey copy(CompileContext cc, IntObjMap<Var> vm) {
        return new OrderKey(this.info, this.expr.copy(cc, vm), this.desc, this.least, this.coll);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        return this;
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrderKey)) {
            return false;
        }
        OrderKey k = (OrderKey)obj;
        return this.desc == k.desc && this.least == k.least && Objects.equals(this.coll, k.coll) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem("dir", Token.token(this.desc ? "descending" : "ascending"), Token.token("empty"), Token.token(this.least ? "least" : "greatest"));
        this.expr.plan(elem);
        plan.add(elem);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.expr.toString());
        if (this.desc) {
            tb.add(32).add("descending");
        }
        tb.add(32).add("empty").add(32).add(this.least ? "least" : "greatest");
        if (this.coll != null) {
            tb.add(32).add("collation").add(" \"").add(this.coll.uri()).add(34);
        }
        return tb.toString();
    }
}

