/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Set;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.list.ANodeBuilder;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Union
extends Set {
    public Union(InputInfo info, Expr ... exprs) {
        super(info, exprs);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        super.optimize(cc);
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            if (expr == Empty.SEQ) {
                cc.info("remove % from %", expr, this.description());
                continue;
            }
            list.add(expr);
        }
        if (list.isEmpty()) {
            return Empty.SEQ;
        }
        if (list.size() == 1 && this.iterable) {
            return (Expr)list.get(0);
        }
        this.exprs = (Expr[])list.finish();
        return this;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        Union un = new Union(this.info, Union.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
        un.iterable = this.iterable;
        return this.copyType(un);
    }

    @Override
    public ANodeBuilder eval(Iter[] iters, QueryContext qc) throws QueryException {
        ANodeBuilder nodes = new ANodeBuilder();
        for (Iter iter : iters) {
            Item item;
            while ((item = qc.next(iter)) != null) {
                nodes.add(this.toNode(item));
            }
        }
        return nodes;
    }

    @Override
    protected NodeIter iter(Iter[] iters, QueryContext qc) {
        return new Set.SetIter(qc, iters){

            @Override
            public ANode next() throws QueryException {
                if (this.nodes == null) {
                    int il = this.iter.length;
                    this.nodes = new ANode[il];
                    for (int i = 0; i < il; ++i) {
                        this.next(i);
                    }
                }
                int m = -1;
                int il = this.nodes.length;
                for (int i = 0; i < il; ++i) {
                    int d;
                    if (this.nodes[i] == null) continue;
                    int n = d = m == -1 ? 1 : this.nodes[m].diff(this.nodes[i]);
                    if (d == 0) {
                        this.next(i--);
                        continue;
                    }
                    if (d <= 0) continue;
                    m = i;
                }
                if (m == -1) {
                    return null;
                }
                ANode it = this.nodes[m];
                this.next(m);
                return it;
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Union && super.equals(obj);
    }
}

