/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class TypeCheck
extends Single {
    private final StaticContext sc;
    public final boolean promote;

    public TypeCheck(StaticContext sc, InputInfo info, Expr expr, SeqType seqType, boolean promote) {
        super(info, expr, seqType);
        this.sc = sc;
        this.promote = promote;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Occ occ;
        SeqType st;
        SeqType at = this.expr.seqType();
        if (at.instanceOf(st = this.seqType())) {
            cc.info("remove type check: %", st + " -> " + this.expr);
            return this.expr;
        }
        if (this.expr instanceof FuncItem && st.type instanceof FuncType) {
            if (!st.occ.check(1L)) {
                throw QueryError.typeError(this.expr, st, null, this.info);
            }
            FuncItem fi = (FuncItem)this.expr;
            return cc.replaceWith(this, fi.coerceTo((FuncType)st.type, cc.qc, this.info, true));
        }
        if (this.expr instanceof Value) {
            return cc.preEval(this);
        }
        if (at.type.instanceOf(st.type) && (occ = at.occ.intersect(st.occ)) == null) {
            throw QueryError.typeError(this.expr, st, null, this.info);
        }
        Expr opt = this.expr.typeCheck(this, cc);
        if (opt != null) {
            cc.info("remove type check: %", st + " -> " + opt);
            return opt;
        }
        return this;
    }

    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final SeqType st = this.seqType();
        final Iter iter = this.expr.iter(qc);
        return new Iter(){
            final ItemList items = new ItemList();
            int c;
            int i;

            @Override
            public Item next() throws QueryException {
                Item item;
                while (this.c == this.items.size()) {
                    this.items.size(0);
                    this.c = 0;
                    item = qc.next(iter);
                    if (item == null || st.instance(item)) {
                        this.items.add(item);
                        continue;
                    }
                    if (TypeCheck.this.promote) {
                        st.promote(item, null, this.items, qc, TypeCheck.this.sc, TypeCheck.this.info, false);
                        continue;
                    }
                    throw QueryError.typeError(TypeCheck.this.expr, st, null, TypeCheck.this.info);
                }
                item = (Item)this.items.get(this.c);
                this.items.set(this.c++, null);
                if (item == null && this.i < st.occ.min || this.i > st.occ.max) {
                    throw QueryError.typeError(TypeCheck.this.expr, st, null, TypeCheck.this.info);
                }
                ++this.i;
                return item;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value = this.expr.value(qc);
        SeqType st = this.seqType();
        if (st.instance(value)) {
            return value;
        }
        if (this.promote) {
            return st.promote(value, null, qc, this.sc, this.info, false);
        }
        throw QueryError.typeError(value, st, null, this.info);
    }

    public boolean isRedundant(Var var) {
        return (!this.promote || var.promotes()) && var.declaredType().instanceOf(this.seqType());
    }

    public Expr check(Expr ex, CompileContext cc) throws QueryException {
        SeqType st;
        SeqType at = ex.seqType();
        return at.instanceOf(st = this.seqType()) ? ex : new TypeCheck(this.sc, this.info, ex, st, this.promote).optimize(cc);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeCheck)) {
            return false;
        }
        TypeCheck tc = (TypeCheck)obj;
        return this.seqType().eq(tc.seqType()) && this.promote == tc.promote && super.equals(obj);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new TypeCheck(this.sc, this.info, this.expr.copy(cc, vm), this.seqType(), this.promote);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem("as", this.seqType());
        if (this.promote) {
            elem.add(TypeCheck.planAttr("promote", true));
        }
        TypeCheck.addPlan(plan, elem, this.expr);
    }

    @Override
    public String toString() {
        return "((: " + this.seqType() + ", " + this.promote + " :) " + this.expr + ')';
    }
}

