/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.SwitchGroup;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Switch
extends ParseExpr {
    private Expr cond;
    private SwitchGroup[] groups;

    public Switch(InputInfo info, Expr cond, SwitchGroup[] groups) {
        super(info, SeqType.ITEM_ZM);
        this.cond = cond;
        this.groups = groups;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        for (SwitchGroup group : this.groups) {
            group.checkUp();
        }
        int gl = this.groups.length;
        Expr[] tmp = new Expr[gl];
        for (int g = 0; g < gl; ++g) {
            tmp[g] = this.groups[g].exprs[0];
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        this.cond = this.cond.compile(cc);
        for (SwitchGroup group : this.groups) {
            group.compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr expr = this.opt(cc);
        if (expr != this) {
            return cc.replaceWith(this, expr);
        }
        SeqType st = this.groups[0].exprs[0].seqType();
        int gl = this.groups.length;
        for (int g = 1; g < gl; ++g) {
            st = st.union(this.groups[g].exprs[0].seqType());
        }
        this.exprType.assign(st);
        return this;
    }

    private Expr opt(CompileContext cc) throws QueryException {
        ExprList cases = new ExprList();
        Item item = this.cond instanceof Value ? this.cond.atomItem(cc.qc, this.info) : null;
        ArrayList<SwitchGroup> tmpGroups = new ArrayList<SwitchGroup>();
        for (SwitchGroup group : this.groups) {
            int el = group.exprs.length;
            Expr ret = group.exprs[0];
            ExprList list = (ExprList)((Object)new ExprList(el).add(ret));
            for (int e = 1; e < el; ++e) {
                Expr expr = group.exprs[e];
                if (this.cond instanceof Value && expr instanceof Value) {
                    Item cs = expr.atomItem(cc.qc, this.info);
                    if (item == cs || cs != null && item != null && item.equiv(cs, null, this.info)) {
                        return ret;
                    }
                    cc.info("remove % from %", expr, this.description());
                    continue;
                }
                if (cases.contains(expr)) {
                    cc.info("remove % from %", expr, this.description());
                    continue;
                }
                cases.add(expr);
                list.add(expr);
            }
            if (list.size() <= 1 && el != 1) continue;
            group.exprs = (Expr[])list.finish();
            tmpGroups.add(group);
        }
        if (tmpGroups.size() != this.groups.length) {
            cc.info("simplify %", this);
            this.groups = tmpGroups.toArray(new SwitchGroup[tmpGroups.size()]);
        }
        Expr expr = this.groups[0].exprs[0];
        int gl = this.groups.length;
        for (int g = 1; g < gl; ++g) {
            if (expr.equals(this.groups[g].exprs[0])) continue;
            return this;
        }
        return expr;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.getCase(qc).iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.getCase(qc).value(qc);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.getCase(qc).item(qc, this.info);
    }

    @Override
    public boolean isVacuous() {
        for (SwitchGroup group : this.groups) {
            if (group.exprs[0].isVacuous()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean has(Flag ... flags) {
        for (SwitchGroup group : this.groups) {
            if (!group.has(flags)) continue;
            return true;
        }
        return this.cond.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        for (SwitchGroup group : this.groups) {
            if (group.removable(var)) continue;
            return false;
        }
        return this.cond.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        VarUsage max = VarUsage.NEVER;
        VarUsage curr = VarUsage.NEVER;
        for (SwitchGroup cs : this.groups) {
            curr = curr.plus(cs.countCases(var));
            max = max.max(curr.plus(cs.count(var)));
        }
        return max.plus(this.cond.count(var));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = Switch.inlineAll(this.groups, var, ex, cc);
        Expr cn = this.cond.inline(var, ex, cc);
        if (cn != null) {
            changed = true;
            this.cond = cn;
        }
        return changed ? this.optimize(cc) : null;
    }

    private Expr getCase(QueryContext qc) throws QueryException {
        Item item = this.cond.atomItem(qc, this.info);
        for (SwitchGroup group : this.groups) {
            int gl = group.exprs.length;
            for (int e = 1; e < gl; ++e) {
                Item cs = group.exprs[e].atomItem(qc, this.info);
                if (item != cs && (item == null || cs == null || !item.equiv(cs, null, this.info))) continue;
                return group.exprs[0];
            }
            if (gl != 1) continue;
            return group.exprs[0];
        }
        throw Util.notExpected();
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Switch(this.info, this.cond.copy(cc, vm), (SwitchGroup[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.groups)));
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        for (SwitchGroup group : this.groups) {
            group.markTailCalls(cc);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.cond.accept(visitor) && Switch.visitAll(visitor, this.groups);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (SwitchGroup group : this.groups) {
            size += ((Expr)group).exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Switch)) {
            return false;
        }
        Switch s = (Switch)obj;
        return this.cond.equals(s.cond) && Array.equals(this.groups, s.groups);
    }

    @Override
    public void plan(FElem plan) {
        Switch.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.cond, this.groups});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("switch(" + this.cond + ")");
        for (SwitchGroup group : this.groups) {
            sb.append(group);
        }
        return sb.toString();
    }
}

