/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.LinkedList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.For;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.Function;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.Array;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.util.InputInfo;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjMap;

public final class Lookup
extends Arr {
    public Lookup(InputInfo info, Expr ... expr) {
        super(info, SeqType.ITEM_ZM, expr);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        long ks;
        Expr keys = this.exprs[0];
        long l = ks = keys.seqType().mayBeArray() ? -1L : keys.size();
        if (this.exprs.length == 1) {
            if (this.seqType(cc.qc.focus.value, keys) && ks == 0L) {
                return cc.replaceWith(this, keys);
            }
            return this;
        }
        Expr ctx = this.exprs[1];
        long es = ctx.size();
        if (this.seqType(ctx, keys)) {
            if ((ctx instanceof Map || ctx instanceof Array) && keys instanceof Value) {
                return cc.preEval(this);
            }
            if (es == 0L) {
                return cc.replaceWith(this, ctx);
            }
            if (ks == 0L) {
                return cc.replaceWith(this, keys);
            }
            if (keys != Str.WC) {
                Expr expr = this;
                if (es == 1L) {
                    expr = ks == 1L ? new DynFuncCall(this.info, cc.sc(), ctx, keys).optimize(cc) : cc.function(Function.FOR_EACH, this.info, this.exprs);
                } else if (keys instanceof Value) {
                    LinkedList<Clause> clauses = new LinkedList<Clause>();
                    Var c = cc.vs().addNew(new QNm("c"), null, false, cc.qc, this.info);
                    clauses.add(new For(c, null, null, ctx, false));
                    Var k = cc.vs().addNew(new QNm("k"), null, false, cc.qc, this.info);
                    clauses.add(new For(k, null, null, keys, false));
                    VarRef rc = new VarRef(this.info, c);
                    VarRef rk = new VarRef(this.info, k);
                    DynFuncCall ret = new DynFuncCall(this.info, cc.sc(), (Expr)rc, rk);
                    expr = new GFLWOR(this.info, clauses, ret).optimize(cc);
                }
                return cc.replaceWith(this, expr);
            }
        }
        return this;
    }

    private boolean seqType(Expr ctx, Expr keys) {
        if (ctx == null) {
            return false;
        }
        Type type = ctx.seqType().type;
        boolean map = type instanceof MapType;
        boolean array = type instanceof ArrayType;
        if (!map && !array) {
            return false;
        }
        SeqType st = ((FuncType)type).declType;
        Occ occ = st.occ;
        if (map) {
            occ = occ.union(Occ.ZERO);
        }
        if (keys == Str.WC || ctx.size() != 1L || !keys.seqType().oneNoArray()) {
            occ = occ.union(Occ.ONE_MORE);
        }
        this.exprType.assign(st.type, occ);
        return true;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Item item;
        BasicIter<Item> iter = this.exprs.length == 1 ? this.ctxValue(qc).iter() : this.exprs[1].iter(qc);
        Expr keys = this.exprs[0];
        ValueBuilder vb = new ValueBuilder(qc);
        while ((item = qc.next(iter)) != null) {
            Item key;
            if (!(item instanceof Map) && !(item instanceof Array)) {
                throw QueryError.LOOKUP_X.get(this.info, item);
            }
            FItem fit = (FItem)item;
            if (keys == Str.WC) {
                if (fit instanceof Map) {
                    ((Map)fit).values(vb);
                    continue;
                }
                for (Value value : ((Array)item).members()) {
                    vb.add(value);
                }
                continue;
            }
            Iter ir = keys.atomIter(qc, this.info);
            while ((key = qc.next(ir)) != null) {
                vb.add(fit.invokeValue(qc, this.info, key));
            }
        }
        return vb.value();
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.CTX.in(flags) && this.exprs.length == 1 || super.has(flags);
    }

    @Override
    public Lookup copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Lookup(this.info, Lookup.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Lookup && super.equals(obj);
    }

    @Override
    public String toString() {
        long val;
        Expr keys;
        StringBuilder sb = new StringBuilder();
        if (this.exprs.length > 1) {
            sb.append(this.exprs[1]);
        }
        if ((keys = this.exprs[0]) == Str.WC) {
            return sb.append("?*").toString();
        }
        if (keys instanceof Str) {
            Str str = (Str)keys;
            if (XMLToken.isNCName(str.string())) {
                return sb.append('?').append(str.toJava()).toString();
            }
        } else if (keys instanceof Int && (val = ((Int)keys).itr()) >= 0L) {
            return sb.append('?').append(val).toString();
        }
        return sb.append("?(").append(keys).append(')').toString();
    }
}

