/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.dot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.basex.data.DataText;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerMode;
import org.basex.io.serial.dot.DOTData;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.util.ft.FTPos;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class DOTSerializer
extends OutputSerializer {
    private final boolean compact;
    private final ArrayList<IntList> children = new ArrayList(1);
    private final TokenBuilder tb = new TokenBuilder();
    private final IntList nodes = new IntList();
    private int count;

    public DOTSerializer(OutputStream os, boolean compact) throws IOException {
        super(PrintOutput.get(os), SerializerMode.DEFAULT.get());
        this.compact = compact;
        this.out.print(DOTData.HEADER);
    }

    @Override
    public void close() throws IOException {
        this.indent();
        this.out.print("}");
    }

    @Override
    protected void startOpen(QNm name) {
        this.tb.reset();
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) {
        this.tb.addExt("\\n%: %", name, value);
    }

    @Override
    protected void finishOpen() throws IOException {
        byte[] attr = this.tb.toArray();
        String color = DOTData.color(this.elem.string());
        if (color == null) {
            color = attr.length == 0 ? "303030" : "909090";
        }
        this.print(Token.concat(this.elem.string(), attr), color);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        int c = this.nodes.get(this.level);
        IntList il = this.child(this.level);
        int is = il.size();
        for (int i = 0; i < is; ++i) {
            this.indent();
            this.out.print(Util.info("node% -> node%;", c, il.get(i)));
        }
        il.reset();
    }

    @Override
    protected void text(byte[] value, FTPos ftp) throws IOException {
        this.print(Token.normalize(value), "6666FF");
    }

    @Override
    protected void comment(byte[] value) throws IOException {
        this.print(new TokenBuilder(DataText.COMM_O).add(Token.normalize(value)).add(DataText.COMM_C).finish(), "3366FF");
    }

    @Override
    protected void pi(byte[] name, byte[] value) throws IOException {
        this.print(new TokenBuilder(DataText.PI_O).add(name).add(Token.SPACE).add(value).add(DataText.PI_C).finish(), "3399FF");
    }

    @Override
    protected void atomic(Item item) throws IOException {
        try {
            this.print(Token.normalize(item.string(null)), "3366CC");
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
    }

    private void print(byte[] value, String col) throws IOException {
        String txt = Token.string(Token.chop(value, 60)).replaceAll("[\"\r\n]", "'");
        if (this.compact) {
            txt = txt.replaceAll("\\\\n\\w+:", "\\\\n");
        }
        this.indent();
        this.out.print(Util.info("node% [label=\"%\" color=\"#%\"];", this.count, txt, col));
        this.nodes.set(this.level, this.count);
        if (this.level > 0) {
            this.child(this.level - 1).add(this.count);
        }
        ++this.count;
    }

    private IntList child(int index) {
        while (index >= this.children.size()) {
            this.children.add(new IntList());
        }
        return this.children.get(index);
    }
}

