/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.list.BoolList;

public final class JsonBasicConverter
extends JsonXmlConverter {
    private final BoolList addPairs = new BoolList();
    private final boolean escape = this.jopts.get(JsonParserOptions.ESCAPE);
    private byte[] name;

    JsonBasicConverter(JsonParserOptions opts) throws QueryIOException {
        super(opts);
        this.addPairs.add(true);
        JsonParserOptions.JsonDuplicates dupl = this.jopts.get(JsonParserOptions.DUPLICATES);
        if (dupl == JsonParserOptions.JsonDuplicates.USE_LAST) {
            throw new QueryIOException(QueryError.JSON_OPTIONS_X.get(null, new Object[]{JsonParserOptions.DUPLICATES.name(), dupl}));
        }
    }

    @Override
    void openObject() {
        this.open(JsonConstants.MAP);
    }

    @Override
    void openPair(byte[] key, boolean add) {
        this.name = key;
        this.addPairs.add(this.add() && add);
    }

    @Override
    void closePair(boolean add) {
        this.addPairs.pop();
    }

    @Override
    void closeObject() {
        this.close();
    }

    @Override
    void openArray() {
        this.open(JsonConstants.ARRAY);
    }

    @Override
    void openItem() {
    }

    @Override
    void closeItem() {
    }

    @Override
    void closeArray() {
        this.close();
    }

    @Override
    public void numberLit(byte[] value) {
        if (this.add()) {
            this.addElem(JsonConstants.NUMBER).add(value);
        }
    }

    @Override
    public void stringLit(byte[] value) {
        if (this.add()) {
            FElem elem = this.addElem(JsonConstants.STRING).add(value);
            if (this.escape && Token.contains(value, 92)) {
                elem.add(JsonConstants.ESCAPED, Token.TRUE);
            }
        }
    }

    @Override
    public void nullLit() {
        if (this.add()) {
            this.addElem(JsonConstants.NULL);
        }
    }

    @Override
    public void booleanLit(byte[] value) {
        if (this.add()) {
            this.addElem(JsonConstants.BOOLEAN).add(value);
        }
    }

    private FElem addElem(byte[] type) {
        FElem elem = new FElem(type, QueryText.FN_URI);
        if (this.curr == null) {
            elem.declareNS();
        }
        if (this.name != null) {
            elem.add(JsonConstants.KEY, this.name);
            if (this.escape && Token.contains(this.name, 92)) {
                elem.add(JsonConstants.ESCAPED_KEY, Token.TRUE);
            }
            this.name = null;
        }
        if (this.curr != null) {
            this.curr.add(elem);
        } else {
            this.curr = elem;
        }
        return elem;
    }

    private void open(byte[] type) {
        if (this.add()) {
            this.curr = this.addElem(type);
        }
    }

    private void close() {
        FElem par;
        if (this.add() && (par = (FElem)this.curr.parent()) != null) {
            this.curr = par;
        }
    }

    private boolean add() {
        return this.addPairs.peek();
    }
}

