/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.util.Arrays;
import org.basex.io.out.PrintOutput;
import org.basex.util.Array;
import org.basex.util.Token;

public final class ArrayOutput
extends PrintOutput {
    private byte[] buffer = new byte[8];

    @Override
    public void write(int b) {
        int s = (int)this.size;
        if ((long)s == this.max) {
            return;
        }
        byte[] bffr = this.buffer;
        if (s == bffr.length) {
            bffr = Arrays.copyOf(bffr, Array.newSize(s));
        }
        bffr[s] = (byte)b;
        this.buffer = bffr;
        this.size = s + 1;
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.buffer, (int)this.size);
    }

    public byte[] next() {
        byte[] lst = this.toArray();
        this.reset();
        return lst;
    }

    public byte[] finish() {
        byte[] bffr = this.buffer;
        this.buffer = null;
        int s = (int)this.size;
        return s == 0 ? Token.EMPTY : (s == bffr.length ? bffr : Arrays.copyOf(bffr, s));
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public void reset() {
        this.size = 0L;
    }

    public String toString() {
        return Token.string(this.buffer, 0, (int)this.size);
    }
}

