/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.IndexTree;
import org.basex.index.IndexType;
import org.basex.index.ValuesBuilder;
import org.basex.index.value.DiskValues;
import org.basex.index.value.DiskValuesMerger;
import org.basex.index.value.UpdatableDiskValues;
import org.basex.io.out.DataOutput;
import org.basex.io.random.DataAccess;
import org.basex.util.Num;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class DiskValuesBuilder
extends ValuesBuilder {
    private IndexTree index;

    public DiskValuesBuilder(Data data, IndexType type) {
        super(data, type);
        this.index = new IndexTree(type);
    }

    @Override
    public DiskValues build() throws IOException {
        Util.debug(this.detailedInfo(), new Object[0]);
        try {
            boolean updindex = this.data.meta.updindex;
            this.pre = 0;
            while (this.pre < this.size) {
                if ((this.pre & 0xFFF) == 0) {
                    this.check();
                }
                if (this.indexEntry()) {
                    int id;
                    int n = id = updindex ? this.data.id(this.pre) : this.pre;
                    if (this.tokenize) {
                        int pos = 0;
                        for (byte[] token : Token.distinctTokens(this.data.text(this.pre, this.text))) {
                            this.index.add(token, id, pos++);
                            ++this.count;
                        }
                    } else if (this.data.textLen(this.pre, this.text) <= this.data.meta.maxlen) {
                        this.index.add(this.data.text(this.pre, this.text), id, 0);
                        ++this.count;
                    }
                }
                ++this.pre;
            }
            this.writeIndex(this.splits > 0);
            if (this.splits > 1) {
                this.index = null;
                this.clean();
                this.merge();
            }
            this.finishIndex();
            return updindex ? new UpdatableDiskValues(this.data, this.type) : new DiskValues(this.data, this.type);
        }
        catch (Throwable th) {
            this.data.meta.drop(DiskValues.fileSuffix(this.type) + ".+");
            throw th;
        }
    }

    @Override
    protected void check() throws IOException {
        super.check();
        if (this.splitRequired()) {
            this.writeIndex(true);
            this.index = new IndexTree(this.type);
            this.clean();
        }
    }

    private void merge() throws IOException {
        String f = DiskValues.fileSuffix(this.type);
        int entries = 0;
        try (DataOutput outL = new DataOutput(this.data.meta.dbfile(f + 'l'));
             DataOutput outR = new DataOutput(this.data.meta.dbfile(f + 'r'));){
            outL.write4(0);
            IntList ml = new IntList();
            IntList id = new IntList();
            IntList pos = this.tokenize ? new IntList() : null;
            DiskValuesMerger[] vm = new DiskValuesMerger[this.splits];
            for (int i = 0; i < this.splits; ++i) {
                vm[i] = new DiskValuesMerger(this.data, this.type, i);
            }
            while (true) {
                this.checkStop();
                int min = -1;
                while (++min < this.splits && vm[min].values.length == 0) {
                }
                if (min == this.splits) {
                    break;
                }
                ml.reset();
                for (int i = min; i < this.splits; ++i) {
                    int d;
                    if (vm[i].values.length == 0 || (d = Token.diff(vm[min].key, vm[i].key)) < 0) continue;
                    if (d > 0) {
                        min = i;
                        ml.reset();
                    }
                    ml.add(i);
                }
                int ms = ml.size();
                for (int m = 0; m < ms; ++m) {
                    DiskValuesMerger t = vm[ml.get(m)];
                    byte[] values = t.values;
                    int vl = values.length;
                    for (int l = 4; l < vl; l += Num.length(values, l)) {
                        id.add(Num.get(values, l));
                        if (pos == null) continue;
                        l += Num.length(values, l);
                        pos.add(Num.get(values, l));
                    }
                    t.next();
                }
                this.write(outL, outR, id, pos);
                ++entries;
            }
        }
        var4_4 = null;
        try (DataAccess da = new DataAccess(this.data.meta.dbfile(f + 'l'));){
            da.write4(entries);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    private void writeIndex(boolean partial) throws IOException {
        String name = DiskValues.fileSuffix(this.type) + (partial ? Integer.valueOf(this.splits) : "");
        try (DataOutput outL = new DataOutput(this.data.meta.dbfile(name + 'l'));
             DataOutput outR = new DataOutput(this.data.meta.dbfile(name + 'r'));){
            outL.write4(this.index.size());
            IntList id = new IntList();
            IntList pos = this.tokenize ? new IntList() : null;
            this.index.init();
            while (this.index.more()) {
                byte[] values = (byte[])this.index.ids.get(this.index.next());
                int vs = Num.size(values);
                if (partial) {
                    outR.write5(outL.size());
                    outL.write(values, 0, vs);
                    continue;
                }
                for (int ip = 4; ip < vs; ip += Num.length(values, ip)) {
                    id.add(Num.get(values, ip));
                    if (pos == null) continue;
                    ip += Num.length(values, ip);
                    pos.add(Num.get(values, ip));
                }
                this.write(outL, outR, id, pos);
            }
        }
        if (partial) {
            var4_4 = null;
            try (DataOutput outT = new DataOutput(this.data.meta.dbfile(name + 't'));){
                this.index.init();
                while (this.index.more()) {
                    outT.writeToken((byte[])this.index.keys.get(this.index.next()));
                }
            }
            catch (Throwable throwable) {
                var4_4 = throwable;
                throw throwable;
            }
        }
        ++this.splits;
    }

    private void write(DataOutput outL, DataOutput outR, IntList id, IntList pos) throws IOException {
        int[] order = null;
        if (this.tokenize) {
            order = id.createOrder();
        } else {
            id.sort();
        }
        int is = id.size();
        outR.write5(outL.size());
        outL.writeNum(is);
        int old = 0;
        for (int i = 0; i < is; ++i) {
            int value = id.get(i);
            outL.writeNum(value - old);
            if (order != null) {
                outL.writeNum(pos.get(order[i]));
            }
            old = value;
        }
        id.reset();
        if (pos != null) {
            pos.reset();
        }
    }
}

