/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.resource;

import java.util.Locale;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.hash.TokenBoolMap;
import org.basex.util.list.TokenList;

final class Binaries {
    private final Data data;

    Binaries(Data d) {
        this.data = d;
    }

    synchronized TokenList bins(String path) {
        TokenList tl = new TokenList();
        String np = MetaData.normPath(path);
        if (np == null || this.data.inMemory()) {
            return tl;
        }
        String exct = Prop.CASE ? np : np.toLowerCase(Locale.ENGLISH);
        String pref = exct.endsWith("/") ? exct : exct + '/';
        for (String f : this.data.meta.binaries().descendants()) {
            String lc;
            String string = lc = Prop.CASE ? f : f.toLowerCase(Locale.ENGLISH);
            if (!exct.isEmpty() && !lc.equals(exct) && !lc.startsWith(pref)) continue;
            tl.add(f);
        }
        return tl.sort(Prop.CASE);
    }

    synchronized void children(byte[] path, boolean dir, TokenBoolMap tbm) {
        if (this.data.inMemory()) {
            return;
        }
        IOFile file = this.data.meta.binary(Token.string(path));
        if (file == null) {
            return;
        }
        for (IOFile f : file.children()) {
            if (!(!dir ^ f.isDir())) continue;
            tbm.put(Token.token(f.name()), true);
        }
    }

    synchronized boolean isDir(String path) {
        if (this.data.inMemory()) {
            return false;
        }
        IOFile bin = this.data.meta.binary(path);
        return bin != null && bin.isDir();
    }
}

