/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.query;

import org.basex.index.query.IndexIterator;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTMatches;

public abstract class FTIndexIterator
implements IndexIterator {
    public static final FTIndexIterator FTEMPTY = new FTIndexIterator(){

        @Override
        public boolean more() {
            return false;
        }

        @Override
        public int pre() {
            return 0;
        }

        @Override
        public FTMatches matches() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void pos(int p) {
        }
    };

    public abstract FTMatches matches();

    public abstract void pos(int var1);

    public static FTIndexIterator union(final FTIndexIterator i1, final FTIndexIterator i2) {
        return new FTIndexIterator(){
            FTIndexIterator ii1;
            FTIndexIterator ii2;
            FTIndexIterator next;
            int diff;

            @Override
            public boolean more() {
                if (this.diff <= 0) {
                    FTIndexIterator fTIndexIterator = this.ii1 = i1.more() ? i1 : null;
                }
                if (this.diff >= 0) {
                    FTIndexIterator fTIndexIterator = this.ii2 = i2.more() ? i2 : null;
                }
                this.diff = this.ii1 != null ? (this.ii2 != null ? this.ii1.pre() - this.ii2.pre() : -1) : 1;
                this.next = this.diff <= 0 ? this.ii1 : this.ii2;
                return this.next != null;
            }

            @Override
            public FTMatches matches() {
                FTMatches all = this.next.matches();
                if (this.diff == 0) {
                    for (FTMatch m : this.ii2.matches()) {
                        all.add(m);
                    }
                }
                return all;
            }

            @Override
            public int pre() {
                return this.next.pre();
            }

            @Override
            public void pos(int p) {
                i1.pos(p);
                i2.pos(p);
            }

            @Override
            public synchronized int size() {
                return i1.size() + i2.size();
            }

            public String toString() {
                return "(" + i1 + " | " + i2 + ')';
            }
        };
    }

    public static FTIndexIterator intersect(final FTIndexIterator i1, final FTIndexIterator i2, final int dis) {
        return new FTIndexIterator(){
            private FTIndexIterator ii1;
            private FTIndexIterator ii2;
            private FTMatches all;

            @Override
            public boolean more() {
                int d = 0;
                while (true) {
                    if (d <= 0) {
                        FTIndexIterator fTIndexIterator = this.ii1 = i1.more() ? i1 : null;
                    }
                    if (d >= 0) {
                        FTIndexIterator fTIndexIterator = this.ii2 = i2.more() ? i2 : null;
                    }
                    if (this.ii1 == null || this.ii2 == null) {
                        return false;
                    }
                    d = this.ii1.pre() - this.ii2.pre();
                    if (d != 0) continue;
                    this.all = this.ii1.matches();
                    FTMatches all2 = this.ii2.matches();
                    if (dis == 0) {
                        for (FTMatch m1 : this.all) {
                            for (FTMatch m2 : all2) {
                                m1.add(m2);
                            }
                        }
                        return true;
                    }
                    if (this.all.phrase(all2, dis)) break;
                }
                return true;
            }

            @Override
            public FTMatches matches() {
                return this.all;
            }

            @Override
            public int pre() {
                return this.ii1.pre();
            }

            @Override
            public void pos(int p) {
                i1.pos(p);
                i2.pos(p);
            }

            @Override
            public synchronized int size() {
                return Math.min(i1.size(), i2.size());
            }

            public String toString() {
                return "(" + i1 + " & " + i2 + ')';
            }
        };
    }
}

