/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Store;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.util.list.IntList;

public final class Replace
extends ACreate {
    public Replace(String path) {
        super(Perm.WRITE, true, path);
    }

    public Replace(String path, String input) {
        super(Perm.WRITE, true, path, input);
    }

    @Override
    protected boolean run() {
        String path;
        if (this.in == null) {
            IO io = IO.get(this.args[1]);
            if (!io.exists()) {
                return this.error(Text.RES_NOT_FOUND_X, io);
            }
            this.in = io.inputSource();
        }
        if ((path = MetaData.normPath(this.args[0])) == null) {
            return this.error(Text.PATH_INVALID_X, this.args[0]);
        }
        final Data data = this.context.data();
        final IOFile bin = data.meta.binary(path);
        if (!data.inMemory() && bin == null) {
            return this.error(Text.PATH_INVALID_X, this.args[0]);
        }
        return this.update(data, new ACreate.Code(){

            @Override
            boolean run() {
                return Replace.this.replace(data, bin, path);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replace(Data data, IOFile bin, String path) {
        AtomicUpdateCache auc = new AtomicUpdateCache(data);
        IntList docs = data.resources.docs(path);
        int d = 0;
        int bs = 0;
        if (bin != null && bin.exists()) {
            Store store = new Store(path);
            store.setInput(this.in);
            store.lock = false;
            if (!store.run(this.context)) {
                return this.error(store.info(), new Object[0]);
            }
            bs = 1;
        } else {
            Add add = new Add(path);
            try {
                add.setInput(this.in);
                add.init(this.context, this.out);
                if (!add.build()) {
                    boolean bl = this.error(add.info(), new Object[0]);
                    return bl;
                }
                if (docs.isEmpty()) {
                    auc.addInsert(data.meta.size, -1, add.clip);
                } else {
                    auc.addReplace(docs.get(d++), add.clip);
                }
                this.context.invalidate();
            }
            finally {
                add.finish();
            }
        }
        int ds = docs.size();
        while (d < ds) {
            auc.addDelete(docs.get(d));
            ++d;
        }
        auc.execute(false);
        return this.info(Text.RES_REPLACED_X_X, ds + bs, this.jc().performance);
    }
}

