/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.cmd.CreateIndex;
import org.basex.core.cmd.DropIndex;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.IdPreMap;
import org.basex.index.IndexType;
import org.basex.index.stats.Stats;
import org.basex.util.list.IntList;

public final class Optimize
extends ACreate {
    private int pre;
    private int size;

    public Optimize() {
        super(Perm.WRITE, true, new String[0]);
    }

    @Override
    protected boolean run() {
        final Data data = this.context.data();
        final MetaData meta = data.meta;
        this.size = meta.size;
        return this.update(data, new ACreate.Code(){

            @Override
            boolean run() throws IOException {
                boolean autooptimize = Optimize.this.options.get(MainOptions.AUTOOPTIMIZE);
                if (autooptimize != data.meta.autooptimize) {
                    data.meta.autooptimize = autooptimize;
                    data.meta.dirty = true;
                }
                Optimize.optimize(data, Optimize.this);
                return Optimize.this.info(Text.DB_OPTIMIZED_X, new Object[]{meta.name, Optimize.this.jc().performance});
            }
        });
    }

    @Override
    public double progressInfo() {
        return (double)this.pre / (double)this.size;
    }

    @Override
    public boolean stoppable() {
        return false;
    }

    @Override
    public String detailedInfo() {
        return Text.CREATE_STATS_D;
    }

    public static void finish(Data data) throws IOException {
        if (data.closed()) {
            return;
        }
        if (data.meta.lastid < data.meta.size - 1) {
            Optimize.optimizeIds(data);
        }
        if (data.meta.autooptimize) {
            Optimize.optimize(data, null);
        }
    }

    public static void optimize(Data data, Optimize cmd) throws IOException {
        Optimize.optimize(data, false, false, false, false, cmd);
    }

    public static void optimize(Data data, boolean enforceText, boolean enforceAttr, boolean enforceToken, boolean enforceFt, Optimize cmd) throws IOException {
        MetaData meta = data.meta;
        if (!meta.uptodate) {
            data.paths.init();
            data.elemNames.init();
            data.attrNames.init();
            meta.dirty = true;
            IntList pars = new IntList();
            IntList elemStack = new IntList();
            int n = 0;
            for (int pre = 0; pre < meta.size; ++pre) {
                byte kind = (byte)data.kind(pre);
                int par = data.parent(pre, kind);
                while (!pars.isEmpty() && pars.peek() > par) {
                    pars.pop();
                    elemStack.pop();
                }
                int level = pars.size();
                if (kind == 0) {
                    data.paths.index(0, (byte)0, level);
                    pars.push(pre);
                    elemStack.push(0);
                    ++n;
                } else if (kind == 1) {
                    int id = data.nameId(pre);
                    data.elemNames.index(data.elemNames.key(id));
                    data.paths.index(id, (byte)1, level);
                    pars.push(pre);
                    elemStack.push(id);
                } else if (kind == 3) {
                    int id = data.nameId(pre);
                    byte[] value = data.text(pre, false);
                    data.attrNames.index(data.attrNames.key(id), value);
                    data.paths.index(id, (byte)3, level, value, meta);
                } else {
                    byte[] value = data.text(pre, true);
                    if (level > 1) {
                        Stats stats = data.elemNames.stats(elemStack.peek());
                        if (kind == 2) {
                            stats.add(value, meta);
                        } else {
                            stats.setLeaf(false);
                        }
                    }
                    data.paths.index(0, kind, level, value, meta);
                }
                if (cmd == null) continue;
                cmd.pre = pre;
            }
            meta.ndocs = n;
            meta.uptodate = true;
        }
        Optimize.optimize(IndexType.TEXT, data, meta.createtext, enforceText, cmd);
        Optimize.optimize(IndexType.ATTRIBUTE, data, meta.createattr, enforceAttr, cmd);
        Optimize.optimize(IndexType.TOKEN, data, meta.createtoken, enforceToken, cmd);
        Optimize.optimize(IndexType.FULLTEXT, data, meta.createft, enforceFt, cmd);
    }

    private static void optimize(IndexType type, Data data, boolean create, boolean enforce, Optimize cmd) throws IOException {
        if (create == data.meta.index(type) && !enforce) {
            return;
        }
        if (create) {
            CreateIndex.create(type, data, cmd);
        } else {
            DropIndex.drop(type, data);
        }
    }

    private static void optimizeIds(Data data) throws IOException {
        MetaData md = data.meta;
        int size = md.size;
        for (int pre = 0; pre < size; ++pre) {
            data.id(pre, pre);
        }
        md.lastid = size - 1;
        md.dirty = true;
        if (data.meta.updindex) {
            data.idmap = new IdPreMap(md.lastid);
            if (data.meta.textindex) {
                Optimize.optimize(IndexType.TEXT, data, true, true, null);
            }
            if (data.meta.attrindex) {
                Optimize.optimize(IndexType.ATTRIBUTE, data, true, true, null);
            }
            if (data.meta.tokenindex) {
                Optimize.optimize(IndexType.TOKEN, data, true, true, null);
            }
        }
    }
}

