/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.data.DataText;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.BoolList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler
implements LexicalHandler {
    protected final Builder builder;
    private final boolean stripNS;
    private final Atts atts = new Atts();
    private final StringBuilder sb = new StringBuilder();
    private final Atts nsp = new Atts();
    private boolean dtd;
    private final BoolList chops = new BoolList();
    private final boolean chop;
    int nodes;

    public SAXHandler(Builder builder, boolean chop, boolean stripNS) {
        this.builder = builder;
        this.stripNS = stripNS;
        this.chop = chop;
        this.chops.push(chop);
    }

    @Override
    public void startElement(String uri, String local, String name, Attributes attr) throws SAXException {
        try {
            int a;
            this.finishText();
            int as = attr.getLength();
            for (int a2 = 0; a2 < as; ++a2) {
                byte[] an = Token.token(attr.getQName(a2));
                byte[] av = Token.token(attr.getValue(a2));
                this.atts.add(this.stripNS ? Token.local(an) : an, av);
            }
            byte[] en = Token.token(name);
            this.builder.openElem(this.stripNS ? Token.local(en) : en, this.atts, this.nsp);
            boolean c = this.chops.peek();
            if (this.chop && (a = this.atts.get(DataText.XML_SPACE)) != -1) {
                byte[] s = this.atts.value(a);
                if (Token.eq(s, DataText.DEFAULT)) {
                    c = true;
                } else if (Token.eq(s, DataText.PRESERVE)) {
                    c = false;
                }
            }
            this.chops.push(c);
            this.atts.reset();
            this.nsp.reset();
            ++this.nodes;
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    @Override
    public void endElement(String uri, String local, String name) throws SAXException {
        try {
            this.finishText();
            this.builder.closeElem();
            this.chops.pop();
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    @Override
    public void characters(char[] chars, int start, int length) {
        this.sb.append(chars, start, length);
    }

    @Override
    public void processingInstruction(String name, String content) throws SAXException {
        if (this.dtd) {
            return;
        }
        try {
            this.finishText();
            this.builder.pi(Token.token(name + ' ' + content));
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    @Override
    public void comment(char[] chars, int start, int length) throws SAXException {
        if (this.dtd) {
            return;
        }
        try {
            this.finishText();
            this.builder.comment(Token.token(new String(chars, start, length)));
        }
        catch (IOException ex) {
            SAXHandler.error(ex);
        }
    }

    private void finishText() throws IOException {
        if (this.sb.length() != 0) {
            String s = this.sb.toString();
            this.builder.text(Token.token(this.chops.peek() ? s.trim() : s));
            this.sb.setLength(0);
        }
    }

    protected static void error(IOException ex) throws SAXException {
        SAXException ioe = new SAXException(Util.message(ex));
        ioe.setStackTrace(ex.getStackTrace());
        throw ioe;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (!this.stripNS) {
            this.nsp.add(Token.token(prefix), Token.token(uri));
        }
    }

    @Override
    public void startDTD(String name, String pid, String sid) {
        this.dtd = true;
    }

    @Override
    public void endDTD() {
        this.dtd = false;
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void endEntity(String entity) {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void startEntity(String entity) {
    }

    static {
        System.setProperty("entityExpansionLimit", "536870912");
        System.setProperty("http.agent", "sax");
    }
}

