/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.html;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.basex.build.html.HtmlOptions;
import org.basex.build.xml.XMLParser;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.TextInput;
import org.basex.util.Reflect;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class HtmlParser
extends XMLParser {
    private static final String NAME = "TagSoup";
    private static final String FEATURES = "http://www.ccil.org/~cowan/tagsoup/features/";
    private static final String PCLASS = "org.ccil.cowan.tagsoup.Parser";
    private static final String WCLASS = "org.ccil.cowan.tagsoup.XMLWriter";
    private static final Class<?> READER = Reflect.find("org.ccil.cowan.tagsoup.Parser");
    private static final Constructor<?> WRITER = Reflect.find(Reflect.find("org.ccil.cowan.tagsoup.XMLWriter"), Writer.class);
    private static final Method METHOD = Reflect.method(Reflect.find("org.ccil.cowan.tagsoup.XMLWriter"), "setOutputProperty", String.class, String.class);

    public static boolean available() {
        return READER != null;
    }

    public static String parser() {
        return HtmlParser.available() ? NAME : "";
    }

    public HtmlParser(IO source, MainOptions opts) throws IOException {
        this(source, opts, opts.get(MainOptions.HTMLPARSER));
    }

    public HtmlParser(IO source, MainOptions opts, HtmlOptions hopts) throws IOException {
        super(HtmlParser.toXML(source, hopts), opts);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IO toXML(IO io, HtmlOptions opts) throws IOException {
        if (READER == null) {
            return io;
        }
        try (TextInput ti = new TextInput(io);){
            String enc = ti.encoding();
            byte[] content = ti.content();
            byte[] encoding = Token.token("charset=");
            int cs = Token.indexOf(content, encoding);
            if (cs > 0) {
                int ce = cs += encoding.length;
                int cl = content.length;
                while (++ce < cl && content[ce] > 40) {
                }
                enc = Token.string(Token.substring(content, cs, ce));
            }
            InputSource is = new InputSource(new ArrayInput(content));
            is.setEncoding(Strings.supported(enc) ? Strings.normEncoding(enc) : "UTF-8");
            StringWriter sw = new StringWriter();
            XMLReader reader = (XMLReader)Reflect.get(READER);
            Object writer = Reflect.get(WRITER, sw);
            if (opts.get(HtmlOptions.HTML).booleanValue()) {
                reader.setFeature("http://xml.org/sax/features/namespaces", false);
                HtmlParser.opt(writer, HtmlOptions.METHOD.name(), "html");
                HtmlParser.opt(writer, HtmlOptions.OMIT_XML_DECLARATION.name(), "yes");
            }
            if (opts.get(HtmlOptions.NONS).booleanValue()) {
                reader.setFeature("http://xml.org/sax/features/namespaces", false);
            }
            if (opts.get(HtmlOptions.OMIT_XML_DECLARATION).booleanValue()) {
                HtmlParser.opt(writer, HtmlOptions.OMIT_XML_DECLARATION.name(), "yes");
            }
            if (opts.get(HtmlOptions.NOBOGONS).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
            }
            if (opts.get(HtmlOptions.NODEFAULTS).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/default-attributes", false);
            }
            if (opts.get(HtmlOptions.NOCOLONS).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/translate-colons", true);
            }
            if (opts.get(HtmlOptions.NORESTART).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/restart-elements", false);
            }
            if (opts.get(HtmlOptions.IGNORABLE).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignorable-whitespace", true);
            }
            if (opts.get(HtmlOptions.EMPTYBOGONS).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", true);
            }
            if (opts.get(HtmlOptions.ANY).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", false);
            }
            if (opts.get(HtmlOptions.NOROOTBOGONS).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/root-bogons", false);
            }
            if (opts.get(HtmlOptions.NOCDATA).booleanValue()) {
                reader.setFeature("http://www.ccil.org/~cowan/tagsoup/features/cdata-elements", false);
            }
            if (opts.get(HtmlOptions.LEXICAL).booleanValue()) {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", writer);
            }
            if (opts.contains(HtmlOptions.METHOD)) {
                HtmlParser.opt(writer, HtmlOptions.METHOD.name(), opts.get(HtmlOptions.METHOD));
            }
            if (opts.contains(HtmlOptions.DOCTYPE_SYSTEM)) {
                HtmlParser.opt(writer, HtmlOptions.DOCTYPE_SYSTEM.name(), opts.get(HtmlOptions.DOCTYPE_SYSTEM));
            }
            if (opts.contains(HtmlOptions.DOCTYPE_PUBLIC)) {
                HtmlParser.opt(writer, HtmlOptions.DOCTYPE_PUBLIC.name(), opts.get(HtmlOptions.DOCTYPE_PUBLIC));
            }
            if (opts.contains(HtmlOptions.ENCODING)) {
                is.setEncoding(opts.get(HtmlOptions.ENCODING));
            }
            reader.setContentHandler((ContentHandler)writer);
            reader.parse(is);
            IOContent iOContent = new IOContent(Token.token(sw.toString()), io.name());
            return iOContent;
        }
        catch (SAXException ex) {
            Util.errln(ex, new Object[0]);
            return io;
        }
    }

    private static void opt(Object writer, String name, String value) {
        Reflect.invoke(METHOD, writer, name, value);
    }
}

