/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.Parser;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.data.MemData;
import org.basex.io.IO;
import org.basex.util.Prop;
import org.basex.util.Util;

public final class MemBuilder
extends Builder {
    private MemData data;
    private int c;

    public MemBuilder(String name, Parser parse) {
        super(name, parse);
    }

    public static MemData build(IO input) throws IOException {
        return MemBuilder.build(Parser.xmlParser(input));
    }

    public static MemData build(Parser parser) throws IOException {
        return MemBuilder.build(parser.source.dbName(), parser);
    }

    public static MemData build(String name, Parser parser) throws IOException {
        return new MemBuilder(name, parser).build();
    }

    @Override
    public MemData build() throws IOException {
        this.dataClip();
        return this.data;
    }

    @Override
    public DataClip dataClip() throws IOException {
        this.init();
        this.meta.assign(this.parser);
        try {
            this.parse();
        }
        finally {
            if (this.data.meta.updindex) {
                this.data.idmap.finish(this.data.meta.lastid);
            }
        }
        return new DataClip(this.data);
    }

    public void init() {
        this.data = new MemData(this.path, this.nspaces, this.parser.options);
        this.meta = this.data.meta;
        this.meta.name = this.dbName;
        this.elemNames = this.data.elemNames;
        this.attrNames = this.data.attrNames;
        this.path.data(this.data);
    }

    public Data data() {
        return this.data;
    }

    @Override
    protected void addDoc(byte[] value) {
        this.data.doc(0, value);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void addElem(int dist, int nameId, int asize, int uriId, boolean ne) {
        this.data.elem(dist, nameId, asize, asize, uriId, ne);
        this.data.insert(this.meta.size);
        if (Prop.debug && (this.c++ & 0x7FFFF) == 0) {
            Util.err(".", new Object[0]);
        }
    }

    @Override
    protected void addAttr(int nameId, byte[] value, int dist, int uriId) {
        this.data.attr(dist, nameId, value, uriId);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void addText(byte[] value, int dist, byte kind) {
        this.data.text(dist, value, kind);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void setSize(int pre, int size) {
        this.data.size(pre, 1, size);
    }
}

