/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.client;

import java.io.InputStream;
import java.io.OutputStream;
import org.basex.api.client.LocalQuery;
import org.basex.api.client.Session;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.Store;
import org.basex.core.parse.CommandParser;
import org.basex.core.users.User;
import org.basex.query.QueryException;
import org.basex.server.LoginException;

public class LocalSession
extends Session {
    private final Context ctx;

    public LocalSession(Context context) {
        this(context, null);
    }

    public LocalSession(Context context, OutputStream output) {
        this(context, output, context.user());
    }

    public LocalSession(Context context, String username, String password) throws LoginException {
        this(context, username, password, null);
    }

    public LocalSession(Context context, String username, String password, OutputStream output) throws LoginException {
        this(context, output, context.users.get(username));
        User user = this.ctx.user();
        if (user == null || !user.matches(password)) {
            throw new LoginException();
        }
    }

    private LocalSession(Context context, OutputStream output, User user) {
        super(output);
        this.ctx = new Context(context);
        this.ctx.user(user);
    }

    @Override
    public void create(String name, InputStream input) throws BaseXException {
        this.execute((Command)new CreateDB(name), input);
    }

    @Override
    public void add(String path, InputStream input) throws BaseXException {
        this.execute((Command)new Add(path), input);
    }

    @Override
    public void replace(String path, InputStream input) throws BaseXException {
        this.execute((Command)new Replace(path), input);
    }

    @Override
    public void store(String path, InputStream input) throws BaseXException {
        this.execute((Command)new Store(path), input);
    }

    private void execute(Command cmd, InputStream input) throws BaseXException {
        cmd.setInput(input);
        cmd.execute(this.ctx);
        this.info = cmd.info();
    }

    @Override
    public LocalQuery query(String query) {
        return new LocalQuery(query, this.ctx, this.out);
    }

    @Override
    public synchronized void close() {
        Close.close(this.ctx);
    }

    @Override
    protected void execute(String command, OutputStream output) throws BaseXException {
        try {
            this.execute(CommandParser.get(command, this.ctx).parseSingle(), output);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    @Override
    protected void execute(Command command, OutputStream output) throws BaseXException {
        command.execute(this.ctx, output);
        this.info = command.info();
    }

    public Context context() {
        return this.ctx;
    }
}

