/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.TimerTask;
import org.basex.api.client.ClientSession;
import org.basex.core.BaseXException;
import org.basex.core.CLI;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.jobs.Jobs;
import org.basex.io.IOFile;
import org.basex.server.ClientListener;
import org.basex.server.Log;
import org.basex.server.LoginException;
import org.basex.util.MainParser;
import org.basex.util.Pair;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Util;

public final class BaseXServer
extends CLI
implements Runnable {
    private final HashSet<ClientListener> authorizing = new HashSet();
    private volatile boolean running;
    private volatile boolean stop;
    private ServerSocket socket;
    private boolean service;
    private boolean daemon;
    private boolean quiet;
    private IOFile stopFile;

    public static void main(String ... args) {
        try {
            new BaseXServer(args);
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
            System.exit(1);
        }
    }

    public BaseXServer(String ... args) throws IOException {
        this(new Context(), args);
        new Jobs(this.context).run();
    }

    public BaseXServer(Context ctx, String ... args) throws IOException {
        super(ctx, args);
        InetAddress addr;
        for (Pair cmd : this.commands) {
            if (this.execute(cmd)) continue;
            return;
        }
        StaticOptions sopts = this.context.soptions;
        int port = sopts.get(StaticOptions.SERVERPORT);
        String host = sopts.get(StaticOptions.SERVERHOST);
        InetAddress inetAddress = addr = host.isEmpty() ? null : InetAddress.getByName(host);
        if (this.stop) {
            this.stop();
            if (!this.quiet) {
                Util.outln(Text.SRV_STOPPED_PORT_X, port);
            }
            Performance.sleep(1000L);
            return;
        }
        if (this.service) {
            BaseXServer.start(port, args);
            if (!this.quiet) {
                Util.outln(Text.SRV_STARTED_PORT_X, port);
            }
            Performance.sleep(1000L);
            return;
        }
        try {
            this.socket = new ServerSocket();
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(addr, port));
            this.stopFile = BaseXServer.stopFile(this.getClass(), port);
        }
        catch (BindException ex) {
            this.context.log.writeServer(Log.LogType.ERROR, Util.message(ex));
            Util.debug(ex);
            throw new BaseXException(Text.SRV_RUNNING_X, port);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.context.log.writeServer(Log.LogType.ERROR, Util.message(ex));
            Util.debug(ex);
            throw new BaseXException(ex.getLocalizedMessage(), new Object[0]);
        }
        new Thread(this).start();
        String startX = Util.info(Text.SRV_STARTED_PORT_X, port);
        if (!this.quiet) {
            if (!this.daemon) {
                Util.outln(this.header(), new Object[0]);
            }
            Util.outln(startX, new Object[0]);
        }
        this.context.log.writeServer(Log.LogType.OK, startX);
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                Socket s = this.socket.accept();
                if (this.stopFile.exists()) {
                    this.close();
                    continue;
                }
                long ka = (long)this.context.soptions.get(StaticOptions.KEEPALIVE).intValue() * 1000L;
                if (ka > 0L) {
                    long ms = System.currentTimeMillis();
                    for (ClientListener cs : this.context.sessions) {
                        if (ms - cs.last <= ka) continue;
                        cs.close();
                    }
                }
                final ClientListener cl = new ClientListener(s, this.context, this);
                if (ka > 0L) {
                    cl.timeout.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            cl.close();
                        }
                    }, ka);
                    this.authorizing.add(cl);
                }
                cl.start();
            }
            catch (SocketException ex) {
                Util.debug(ex);
                break;
            }
            catch (Throwable ex) {
                Util.errln(ex, new Object[0]);
                this.context.log.writeServer(Log.LogType.ERROR, Util.message(ex));
                break;
            }
        }
    }

    public void stop() {
        StaticOptions sopts = this.context.soptions;
        int port = sopts.get(StaticOptions.SERVERPORT);
        String host = sopts.get(StaticOptions.SERVERHOST);
        BaseXServer.stop(host.isEmpty() ? "localhost" : host, port);
    }

    private synchronized void close() {
        if (!this.running) {
            return;
        }
        for (ClientListener cl : this.authorizing) {
            this.remove(cl);
            cl.close();
        }
        this.context.sessions.close();
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            Util.errln(ex, new Object[0]);
            this.context.log.writeServer(Log.LogType.ERROR, Util.message(ex));
        }
        int port = this.context.soptions.get(StaticOptions.SERVERPORT);
        String stopX = Util.info(Text.SRV_STOPPED_PORT_X, port);
        if (!this.quiet) {
            Util.outln(stopX, new Object[0]);
        }
        this.context.log.writeServer(Log.LogType.OK, stopX);
        this.context.close();
        if (!this.stopFile.delete()) {
            this.context.log.writeServer(Log.LogType.ERROR, Util.info(Text.FILE_NOT_DELETED_X, this.stopFile));
        }
        this.running = false;
    }

    @Override
    protected void parseArgs() throws IOException {
        MainParser arg = new MainParser(this);
        block11: while (arg.more()) {
            if (arg.dash()) {
                switch (arg.next()) {
                    case 'c': {
                        this.commands.add(BaseXServer.input(arg.string()));
                        continue block11;
                    }
                    case 'd': {
                        Prop.debug = true;
                        continue block11;
                    }
                    case 'D': {
                        this.daemon = true;
                        continue block11;
                    }
                    case 'n': {
                        this.context.soptions.set(StaticOptions.SERVERHOST, arg.string());
                        continue block11;
                    }
                    case 'p': {
                        this.context.soptions.set(StaticOptions.SERVERPORT, arg.number());
                        continue block11;
                    }
                    case 'q': {
                        this.quiet = true;
                        continue block11;
                    }
                    case 'v': {
                        this.verbose = true;
                        continue block11;
                    }
                    case 'S': {
                        this.service = !this.daemon;
                        continue block11;
                    }
                    case 'z': {
                        this.context.soptions.set(StaticOptions.LOG, false);
                        continue block11;
                    }
                }
                throw arg.usage();
            }
            if ("stop".equalsIgnoreCase(arg.string())) {
                this.stop = true;
                continue;
            }
            throw arg.usage();
        }
    }

    @Override
    public String header() {
        return Util.info(Text.S_CONSOLE_X, "Server");
    }

    @Override
    public String usage() {
        return Text.S_SERVERINFO;
    }

    public static void start(int port, String ... args) throws BaseXException {
        String error = Util.error(Util.start(BaseXServer.class, args), 2000);
        if (error != null) {
            throw new BaseXException(error.trim(), new Object[0]);
        }
        if (!BaseXServer.ping("localhost", port)) {
            throw new BaseXException(Text.CONNECTION_ERROR_X, port);
        }
    }

    public static boolean ping(String host, int port) {
        try {
            ClientSession cs = new ClientSession(host, port, "", "");
            Throwable throwable = null;
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    cs.close();
                }
            }
            return false;
        }
        catch (LoginException ex) {
            Util.debug(ex);
            return true;
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }

    public static void stop(String host, int port) {
        IOFile stopFile = BaseXServer.stopFile(BaseXServer.class, port);
        stopFile.touch();
        try {
            Socket s = new Socket(host, port);
            Throwable throwable = null;
            if (s != null) {
                if (throwable != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    s.close();
                }
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            stopFile.delete();
        }
        do {
            Performance.sleep(10L);
        } while (stopFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ClientListener client) {
        HashSet<ClientListener> hashSet = this.authorizing;
        synchronized (hashSet) {
            client.timeout.cancel();
            this.authorizing.remove(client);
        }
    }
}

