/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.list.ElementList;

public class LongList
extends ElementList {
    protected long[] list;

    public LongList() {
        this(8);
    }

    public LongList(int capacity) {
        this.list = new long[capacity];
    }

    public final LongList add(long element) {
        int s = this.size;
        long[] lst = this.list;
        if (s == lst.length) {
            lst = Arrays.copyOf(lst, this.newSize());
        }
        lst[s] = element;
        this.list = lst;
        this.size = s + 1;
        return this;
    }

    public final LongList add(long ... elements) {
        int s = this.size;
        int l = elements.length;
        int ns = s + l;
        long[] lst = this.list;
        if (ns > lst.length) {
            lst = Arrays.copyOf(lst, this.newSize(ns));
        }
        System.arraycopy(elements, 0, lst, s, l);
        this.list = lst;
        this.size = ns;
        return this;
    }

    public final long get(int index) {
        return this.list[index];
    }

    public final long peek() {
        return this.list[this.size - 1];
    }

    public final long pop() {
        return this.list[--this.size];
    }

    public final void push(long element) {
        this.add(element);
    }

    public final long[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public long[] finish() {
        long[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Arrays.copyOf(lst, s);
    }

    public LongList sort() {
        int s = this.size;
        if (s > 1) {
            Arrays.sort(this.list, 0, s);
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public LongList distinct() {
        block3: {
            if (this.isEmpty()) break block3;
            i = 1;
            j = 1;
            ** GOTO lbl11
            {
                ++j;
                do {
                    if (j < this.size && this.list[i - 1] == this.list[j]) continue block0;
                    if (j < this.size) {
                        this.list[i++] = this.list[j];
                    }
                    ++j;
lbl11:
                    // 2 sources

                } while (j < this.size);
            }
            this.size = i;
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongList)) {
            return false;
        }
        LongList ll = (LongList)obj;
        if (this.size != ll.size) {
            return false;
        }
        int l = 0;
        while (l < this.size) {
            if (this.list[l] != ll.list[l]) {
                return false;
            }
            ++l;
        }
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

