/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URLConnection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.io.IO;
import org.basex.io.IOUrl;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.http.HttpRequest;
import org.basex.util.http.HttpRequestParser;
import org.basex.util.http.HttpResponse;
import org.basex.util.http.HttpText;
import org.basex.util.http.MediaType;
import org.basex.util.options.Options;

public final class HttpClient {
    private final InputInfo info;
    private final MainOptions options;

    public HttpClient(InputInfo info, MainOptions options) {
        this.info = info;
        this.options = options;
    }

    public BasicIter<Item> sendRequest(byte[] href, ANode request, Value bodies) throws QueryException {
        HttpRequest req = new HttpRequestParser(this.info).parse(request, bodies);
        HttpURLConnection conn = null;
        try {
            String url;
            String mediaType = req.attribute(HttpText.Request.OVERRIDE_MEDIA_TYPE);
            String status = req.attribute(HttpText.Request.STATUS_ONLY);
            boolean body = status == null || !Strings.yes(status);
            String string = url = href == null || href.length == 0 ? req.attribute(HttpText.Request.HREF) : Token.string(href);
            if (url == null || url.isEmpty()) {
                throw QueryError.HC_URL.get(this.info, new Object[0]);
            }
            conn = this.connect(url, req);
            if (!req.payload.isEmpty() || !req.parts.isEmpty()) {
                HttpClient.setContentType(conn, req);
                HttpClient.writePayload(conn.getOutputStream(), req);
            }
            BasicIter<Item> basicIter = new HttpResponse(this.info, this.options).getResponse(conn, body, mediaType).iter();
            return basicIter;
        }
        catch (IOException ex) {
            throw QueryError.HC_ERROR_X.get(this.info, ex);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private HttpURLConnection connect(String url, HttpRequest request) throws QueryException, IOException {
        HttpURLConnection conn = this.connection(url, request);
        String user = request.attribute(HttpText.Request.USERNAME);
        String pass = request.attribute(HttpText.Request.PASSWORD);
        if (user != null) {
            if (request.authMethod == StaticOptions.AuthMethod.BASIC) {
                conn.setRequestProperty("Authorization", "Basic " + Base64.encode(String.valueOf(user) + ':' + pass));
            } else if (request.authMethod == StaticOptions.AuthMethod.DIGEST) {
                conn.setRequestProperty("Authorization", "Digest");
                EnumMap<HttpText.Request, String> map = HttpClient.digestHeaders(conn.getHeaderField("WWW-Authenticate"));
                String realm = map.get((Object)HttpText.Request.REALM);
                String nonce = map.get((Object)HttpText.Request.NONCE);
                String uri = conn.getURL().getPath();
                String qop = map.get((Object)HttpText.Request.QOP);
                String nc = "00000001";
                String cnonce = Strings.md5(Long.toString(System.nanoTime()));
                String ha1 = Strings.md5(String.valueOf(user) + ':' + realm + ':' + pass);
                String ha2 = Strings.md5(String.valueOf(request.attribute(HttpText.Request.METHOD)) + ':' + uri);
                String rsp = Strings.md5(String.valueOf(ha1) + ':' + nonce + ':' + "00000001" + ':' + cnonce + ':' + qop + ':' + ha2);
                String creds = (Object)((Object)HttpText.Request.USERNAME) + "=\"" + user + "\"," + (Object)((Object)HttpText.Request.REALM) + "=\"" + realm + "\"," + (Object)((Object)HttpText.Request.NONCE) + "=\"" + nonce + "\"," + (Object)((Object)HttpText.Request.URI) + "=\"" + uri + "\"," + (Object)((Object)HttpText.Request.QOP) + '=' + qop + ',' + (Object)((Object)HttpText.Request.NC) + '=' + "00000001" + ',' + (Object)((Object)HttpText.Request.CNONCE) + "=\"" + cnonce + "\"," + (Object)((Object)HttpText.Request.RESPONSE) + "=\"" + rsp + "\"," + (Object)((Object)HttpText.Request.ALGORITHM) + '=' + "MD5" + ',' + (Object)((Object)HttpText.Request.OPAQUE) + "=\"" + map.get((Object)HttpText.Request.OPAQUE) + '\"';
                conn.disconnect();
                conn = this.connection(url, request);
                conn.setRequestProperty("Authorization", "Digest " + creds);
            }
        }
        return conn;
    }

    private HttpURLConnection connection(String url, HttpRequest request) throws QueryException, IOException {
        URLConnection uc = new IOUrl(url).connection();
        if (!(uc instanceof HttpURLConnection)) {
            throw QueryError.HC_ERROR_X.get(this.info, "Invalid URL: " + url);
        }
        HttpURLConnection conn = (HttpURLConnection)uc;
        String method = request.attribute(HttpText.Request.METHOD);
        if (method != null) {
            String redirect;
            try {
                conn.setRequestMethod(method);
            }
            catch (ProtocolException ex) {
                try {
                    Class<?> c = conn.getClass();
                    while (c != HttpURLConnection.class) {
                        c = c.getSuperclass();
                    }
                    Field f = c.getDeclaredField("method");
                    f.setAccessible(true);
                    f.set(conn, method);
                }
                catch (Throwable th) {
                    Util.debug(th);
                    throw ex;
                }
            }
            conn.setDoOutput(true);
            String timeout = request.attribute(HttpText.Request.TIMEOUT);
            if (timeout != null) {
                conn.setConnectTimeout(Strings.toInt(timeout) * 1000);
                conn.setReadTimeout(Strings.toInt(timeout) * 1000);
            }
            if ((redirect = request.attribute(HttpText.Request.FOLLOW_REDIRECT)) != null) {
                HttpURLConnection.setFollowRedirects(Strings.yes(redirect));
            }
            request.headers.forEach(conn::addRequestProperty);
        }
        return conn;
    }

    private static void setContentType(HttpURLConnection conn, HttpRequest request) {
        String ct;
        String contType = request.headers.get("Content-Type".toLowerCase(Locale.ENGLISH));
        if (contType != null) {
            ct = contType;
        } else {
            ct = request.payloadAtts.get(SerializerOptions.MEDIA_TYPE.name());
            if (request.isMultipart) {
                ct = new TokenBuilder().add(ct).add("; ").add("boundary").add(61).add(request.boundary()).toString();
            }
        }
        conn.setRequestProperty("Content-Type", ct);
    }

    public static EnumMap<HttpText.Request, String> digestHeaders(String auth) {
        EnumMap<HttpText.Request, String> values = new EnumMap<HttpText.Request, String>(HttpText.Request.class);
        if (auth != null) {
            String[] parts = Strings.split(auth, ' ', 2);
            values.put(HttpText.Request.AUTH_METHOD, parts[0]);
            if (parts.length > 1) {
                String[] stringArray = Strings.split(parts[1], ',');
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HttpText.Request r;
                    String header = stringArray[n2];
                    String[] kv = Strings.split(header, '=', 2);
                    String key = kv[0].trim();
                    if (!key.isEmpty() && kv.length == 2 && (r = HttpText.Request.get(key)) != null) {
                        values.put(r, Strings.delete(kv[1], '\"').trim());
                    }
                    ++n2;
                }
            }
        }
        return values;
    }

    public static void writePayload(OutputStream out, HttpRequest request) throws IOException {
        if (request.isMultipart) {
            String boundary = request.boundary();
            for (HttpRequest.Part part : request.parts) {
                ArrayOutput ao = new ArrayOutput();
                HttpClient.writePayload(part.bodyContents, part.bodyAtts, ao);
                out.write(new TokenBuilder().add("--").add(boundary).add(HttpText.CRLF).finish());
                for (Map.Entry<String, String> header : part.headers.entrySet()) {
                    HttpClient.writeHeader(header.getKey(), header.getValue(), out);
                }
                if (!part.headers.containsKey("Content-Type")) {
                    HttpClient.writeHeader("Content-Type", part.bodyAtts.get(SerializerOptions.MEDIA_TYPE.name()), out);
                }
                out.write(HttpText.CRLF);
                out.write(ao.finish());
                out.write(HttpText.CRLF);
            }
            out.write(new TokenBuilder("--").add(boundary).add("--").add(HttpText.CRLF).finish());
        } else {
            HttpClient.writePayload(request.payload, request.payloadAtts, out);
        }
        out.close();
    }

    public static void writeHeader(String key, String value, OutputStream out) throws IOException {
        out.write(new TokenBuilder().add(key).add(": ").add(value).add(HttpText.CRLF).finish());
    }

    private static void writePayload(ItemList payload, Map<String, String> atts, OutputStream out) throws IOException {
        SerializerOptions sopts = new SerializerOptions();
        sopts.set(SerializerOptions.INDENT, Options.YesNo.NO);
        sopts.set(SerializerOptions.NEWLINE, SerializerOptions.Newline.NL);
        String src = null;
        String method = null;
        for (Map.Entry<String, String> entry : atts.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equals("src")) {
                src = value;
                continue;
            }
            if (key.equals(SerializerOptions.METHOD.name())) {
                method = value.equals("binary") ? SerialMethod.BASEX.toString() : value;
                continue;
            }
            sopts.assign(key, value);
            if (method != null || !key.equals(SerializerOptions.MEDIA_TYPE.name())) continue;
            MediaType type = new MediaType(value);
            method = type.is(MediaType.APPLICATION_HTML_XML) ? SerialMethod.XHTML.toString() : (type.is(MediaType.TEXT_HTML) ? SerialMethod.HTML.toString() : (type.isXML() ? SerialMethod.XML.toString() : (type.isText() ? SerialMethod.TEXT.toString() : SerialMethod.BASEX.toString())));
        }
        sopts.assign(SerializerOptions.METHOD.name(), method);
        if (src != null) {
            out.write(IO.get(src).read());
        } else {
            Throwable throwable = null;
            Iterator<Map.Entry<String, String>> iterator = null;
            try (Serializer ser = Serializer.get(out, sopts);){
                for (Item item : payload) {
                    ser.serialize(item);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

