/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;

public abstract class ASet {
    protected int[] buckets;
    protected int[] next;
    protected int size = 1;

    protected ASet() {
    }

    protected ASet(int capacity) {
        int c = 1;
        while (c < capacity) {
            c <<= 1;
        }
        this.buckets = new int[c];
        this.next = new int[c];
    }

    void clear() {
        Arrays.fill(this.buckets, 0);
        this.size = 1;
    }

    public final int size() {
        return this.size - 1;
    }

    public final boolean isEmpty() {
        return this.size == 1;
    }

    protected final void checkSize() {
        if (this.size < this.next.length) {
            return;
        }
        int s = this.size << 1;
        int[] tmp = new int[s];
        int[] nArray = this.buckets;
        int n = this.buckets.length;
        int n2 = 0;
        while (n2 < n) {
            int b;
            int id = b = nArray[n2];
            while (id != 0) {
                int p = this.hash(id) & s - 1;
                int nx = this.next[id];
                this.next[id] = tmp[p];
                tmp[p] = id;
                id = nx;
            }
            ++n2;
        }
        this.buckets = tmp;
        this.next = Arrays.copyOf(this.next, s);
        this.rehash(s);
    }

    protected abstract int hash(int var1);

    protected abstract void rehash(int var1);
}

