/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.TreeMap;
import org.basex.index.IndexType;
import org.basex.index.query.IndexToken;
import org.basex.util.Token;
import org.basex.util.ft.DictionaryStemmer;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.FTSpan;
import org.basex.util.ft.FTUnit;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;
import org.basex.util.ft.Tokenizer;
import org.basex.util.list.StringList;

public final class FTLexer
extends FTIterator
implements IndexToken {
    private final Tokenizer tokens;
    private final FTOpt ftOpt;
    private byte[] text = Token.EMPTY;
    private int lserror;
    private FTIterator iter;
    private FTSpan curr;
    private byte[] ctxt;

    public FTLexer() {
        this(null);
    }

    public FTLexer(FTOpt ftOpt) {
        Language lang;
        this.ftOpt = ftOpt;
        Language language = lang = ftOpt != null ? ftOpt.ln : null;
        if (lang == null) {
            lang = Language.def();
        }
        Tokenizer tkns = Tokenizer.IMPL.get(0);
        for (Tokenizer tknzr : Tokenizer.IMPL) {
            if (!tknzr.supports(lang)) continue;
            tkns = tknzr;
            break;
        }
        this.tokens = tkns.get(ftOpt);
        this.iter = this.tokens;
        if (ftOpt != null && ftOpt.is(FTFlag.ST)) {
            if (ftOpt.sd == null) {
                Stemmer st = Stemmer.IMPL.get(0);
                for (Stemmer stem : Stemmer.IMPL) {
                    if (!stem.supports(lang)) continue;
                    st = stem;
                    break;
                }
                this.iter = st.get(lang, this.iter);
            } else {
                this.iter = new DictionaryStemmer(ftOpt.sd, this.iter);
            }
        }
    }

    public FTLexer original() {
        this.tokens.original = true;
        return this.all();
    }

    public FTLexer all() {
        this.tokens.all = true;
        return this;
    }

    public FTLexer init() {
        this.init(this.text);
        return this;
    }

    public FTLexer lserror(int ls) {
        this.lserror = ls;
        return this;
    }

    public int lserror(byte[] token) {
        return this.lserror == 0 ? token.length >> 2 : this.lserror;
    }

    @Override
    public FTLexer init(byte[] txt) {
        this.text = txt;
        this.iter.init(txt);
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public FTSpan next() {
        this.curr = (FTSpan)this.iter.next();
        return this.curr;
    }

    @Override
    public byte[] nextToken() {
        this.ctxt = this.iter.nextToken();
        return this.ctxt;
    }

    public int count() {
        this.init();
        int c = 0;
        while (this.hasNext()) {
            this.nextToken();
            ++c;
        }
        return c;
    }

    @Override
    public IndexType type() {
        return IndexType.FULLTEXT;
    }

    @Override
    public byte[] get() {
        return this.ctxt != null ? this.ctxt : this.curr.text;
    }

    public FTOpt ftOpt() {
        return this.ftOpt;
    }

    public byte[] text() {
        return this.text;
    }

    public boolean paragraph() {
        return this.tokens.paragraph();
    }

    public int pos(int word, FTUnit unit) {
        return this.tokens.pos(word, unit);
    }

    public int[][] info() {
        return this.tokens.info();
    }

    public FTLexer copy(FTOpt opt) {
        FTOpt to = this.ftOpt;
        to.set(FTFlag.ST, opt.is(FTFlag.ST));
        to.set(FTFlag.DC, opt.is(FTFlag.DC));
        to.ln = opt.ln;
        to.th = opt.th;
        to.sd = opt.sd;
        to.cs = opt.cs != null && opt.cs != FTCase.INSENSITIVE ? FTCase.SENSITIVE : FTCase.INSENSITIVE;
        return new FTLexer(to).init(this.text());
    }

    public static StringList languages() {
        TreeMap<Language, Stemmer> langs = new TreeMap<Language, Stemmer>();
        for (Stemmer stem : Stemmer.IMPL) {
            for (Language l : stem.languages()) {
                if (langs.containsKey(l)) continue;
                for (Tokenizer tknzr : Tokenizer.IMPL) {
                    if (!tknzr.languages().contains(l)) continue;
                    langs.put(l, stem);
                }
            }
        }
        StringList sl = new StringList();
        langs.forEach((key, value) -> {
            String string = sl.add(key + " (" + value + ')');
        });
        return sl.sort();
    }
}

