/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Token {
    public static final byte[] EMPTY = new byte[0];
    public static final byte[] XML = Token.token("xml");
    public static final byte[] XMLC = Token.token("xml:");
    public static final byte[] XMLNS = Token.token("xmlns");
    public static final byte[] XMLNSC = Token.token("xmlns:");
    public static final byte[] ID = Token.token("id");
    public static final byte[] IDREF = Token.token("ref");
    public static final byte[] TRUE = Token.token("true");
    public static final byte[] FALSE = Token.token("false");
    public static final byte[] NAN = Token.token("NaN");
    public static final byte[] INF = Token.token("INF");
    public static final byte[] NINF = Token.token("-INF");
    public static final byte[] MINLONG = Token.token("-9223372036854775808");
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] ZERO = new byte[]{48};
    private static final byte[] MZERO = new byte[]{45, 48};
    public static final byte[] ONE = new byte[]{49};
    public static final byte[] SLASH = new byte[]{47};
    public static final byte[] COLON = new byte[]{58};
    public static final char REPLACEMENT = '\ufffd';
    private static final byte MAXLENGTH = 96;
    private static final int MAXINT = 0xCCCCCCC;
    private static final long MAXLONG = 0xCCCCCCCCCCCCCCCL;
    public static final byte[] HEX = Token.token("0123456789ABCDEF");
    private static final byte[] IRIRES = Token.token("!#$%&*'()+,-./:;=?@[]~_");
    private static final byte[] RES = Token.token("-._~");
    public static final Comparator<byte[]> COMP = Token::diff;
    public static final Comparator<byte[]> LC_COMP = (o1, o2) -> Token.diff(Token.lc(o1), Token.lc(o2));
    private static final int[] CHLEN = new int[]{1, 1, 1, 1, 2, 2, 3, 4};
    private static final byte[] MININT = Token.token("-2147483648");
    private static final int[] INTSIZE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    public static final DecimalFormatSymbols LOC = new DecimalFormatSymbols(Locale.US);
    public static final DecimalFormat SD = new DecimalFormat("0.0##################E0", LOC);
    public static final DecimalFormat DD = new DecimalFormat("#####0.0################", LOC);
    public static final DecimalFormat SF = new DecimalFormat("0.0######E0", LOC);
    public static final DecimalFormat DF = new DecimalFormat("#####0.0######", LOC);
    private static final float[] FLT = new float[]{1.0E17f, 1.0E15f, 1.0E13f, 1.0E11f, -1.0E17f, -1.0E15f, -1.0E13f, -1.0E11f};
    private static final byte[][] FLTSTR = Token.tokens("1.0E17", "1.0E15", "1.0E13", "1.0E11", "-1.0E17", "-1.0E15", "-1.0E13", "-1.0E11");

    private Token() {
    }

    public static String string(byte[] token) {
        return Token.string(token, 0, token.length);
    }

    public static String string(byte[] token, int start, int length) {
        if (length <= 0) {
            return "";
        }
        int e = start + length;
        int p = start;
        while (p < e) {
            if (token[p] < 0) {
                return Token.utf8(token, start, length);
            }
            ++p;
        }
        char[] str = new char[length];
        int p2 = 0;
        while (p2 < length) {
            str[p2] = (char)token[start + p2];
            ++p2;
        }
        return new String(str);
    }

    private static String utf8(byte[] token, int start, int length) {
        StringBuilder sb = new StringBuilder(length << 1);
        int il = Math.min(start + length, token.length);
        int i = start;
        while (i < il) {
            int cp = Token.cp(token, i);
            if (cp < 65536) {
                sb.append((char)cp);
            } else {
                int o = cp - 65536;
                sb.append((char)((o >>> 10) + 55296));
                sb.append((char)((o & 0x3FF) + 56320));
            }
            i += Token.cl(token, i);
        }
        return sb.toString();
    }

    public static boolean ascii(byte[] token) {
        byte[] byArray = token;
        int n = token.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b < 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static byte[] token(String string) {
        int l = string.length();
        if (l == 0) {
            return EMPTY;
        }
        byte[] b = new byte[l];
        int i = 0;
        while (i < l) {
            char c = string.charAt(i);
            if (c > '\u007f') {
                return Token.utf8(string);
            }
            b[i] = (byte)c;
            ++i;
        }
        return b;
    }

    public static byte[][] tokens(String ... strings) {
        byte[][] tokens = new byte[strings.length][];
        int tl = tokens.length;
        int t = 0;
        while (t < tl) {
            tokens[t] = Token.token(strings[t]);
            ++t;
        }
        return tokens;
    }

    private static byte[] utf8(String string) {
        char[] arr = string.toCharArray();
        int al = arr.length;
        TokenBuilder tb = new TokenBuilder(al << 1);
        int c = 0;
        while (c < al) {
            int ch = arr[c];
            tb.add(Character.isHighSurrogate((char)ch) && c < al - 1 && Character.isLowSurrogate(arr[c + 1]) ? Character.toCodePoint((char)ch, arr[++c]) : ch);
            ++c;
        }
        return tb.finish();
    }

    public static byte[] utf8(byte[] token, String encoding) {
        if (encoding == "UTF-8" || Token.ascii(token)) {
            return token;
        }
        try {
            return Token.token(new String(token, encoding));
        }
        catch (Exception ex) {
            Util.debug(ex);
            return EMPTY;
        }
    }

    public static int cp(byte[] token, int pos) {
        byte v = token[pos];
        if ((v & 0xFF) < 192) {
            return v & 0xFF;
        }
        int vl = Token.cl(v);
        if (pos + vl > token.length) {
            return 65533;
        }
        if (vl == 2) {
            return (v & 0x1F) << 6 | token[pos + 1] & 0x3F;
        }
        if (vl == 3) {
            return (v & 0xF) << 12 | (token[pos + 1] & 0x3F) << 6 | token[pos + 2] & 0x3F;
        }
        return (v & 7) << 18 | (token[pos + 1] & 0x3F) << 12 | (token[pos + 2] & 0x3F) << 6 | token[pos + 3] & 0x3F;
    }

    public static int cl(byte cp) {
        return cp >= 0 ? 1 : CHLEN[cp >> 4 & 7];
    }

    public static int cl(byte[] token, int pos) {
        return Token.cl(token[pos]);
    }

    public static int[] cps(byte[] token) {
        int pos = 0;
        int len = token.length;
        int[] cp = new int[len];
        int i = 0;
        while (i < len) {
            cp[pos++] = Token.cp(token, i);
            i += Token.cl(token, i);
        }
        return pos < len ? Arrays.copyOf(cp, pos) : cp;
    }

    public static int length(byte[] token) {
        int tl = token.length;
        if (Token.ascii(token)) {
            return tl;
        }
        int l = 0;
        int t = 0;
        while (t < tl) {
            ++l;
            t += Token.cl(token, t);
        }
        return l;
    }

    public static byte[] token(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static byte[] token(int integer) {
        int q;
        boolean m;
        if (integer == 0) {
            return ZERO;
        }
        if (integer == Integer.MIN_VALUE) {
            return MININT;
        }
        int n = integer;
        boolean bl = m = n < 0;
        if (m) {
            n = -n;
        }
        int j = Token.numDigits(n);
        if (m) {
            ++j;
        }
        byte[] num = new byte[j];
        while (n > 81919) {
            q = n / 10;
            num[--j] = (byte)(n - (q << 3) - (q << 1) + 48);
            n = q;
        }
        while (n != 0) {
            q = n * 52429 >>> 19;
            num[--j] = (byte)(n - (q << 3) - (q << 1) + 48);
            n = q;
        }
        if (m) {
            num[--j] = 45;
        }
        return num;
    }

    public static int numDigits(int integer) {
        int i = 0;
        while (integer > INTSIZE[i]) {
            ++i;
        }
        return i + 1;
    }

    public static byte[] token(long integer) {
        return integer >= Integer.MIN_VALUE && integer <= Integer.MAX_VALUE ? Token.token((int)integer) : Token.token(Long.toString(integer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] token(double dbl) {
        String s;
        byte[] b = Token.tok(dbl);
        if (b != null) {
            return b;
        }
        double a = Math.abs(dbl);
        if (a >= 1.0E-6 && a < 1000000.0) {
            DecimalFormat decimalFormat = DD;
            synchronized (decimalFormat) {
                s = DD.format(dbl);
            }
        }
        DecimalFormat decimalFormat = SD;
        synchronized (decimalFormat) {
            s = SD.format(dbl);
        }
        return Token.chopNumber(Token.token(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] token(float flt) {
        String s1;
        DecimalFormat decimalFormat;
        boolean small;
        byte[] b = Token.tok(flt);
        if (b != null) {
            return b;
        }
        int fl = FLT.length;
        int i = 0;
        while (i < fl) {
            if (flt == FLT[i]) {
                return FLTSTR[i];
            }
            ++i;
        }
        float a = Math.abs(flt);
        boolean bl = small = a >= 1.0E-6f && a < 1000000.0f;
        if (small) {
            decimalFormat = DF;
            synchronized (decimalFormat) {
                s1 = DF.format(flt);
            }
        }
        decimalFormat = SF;
        synchronized (decimalFormat) {
            s1 = SF.format(flt);
        }
        String s2 = Float.toString(flt);
        if (!(s2.length() >= s1.length() || s2.contains("E") && small)) {
            s1 = s2;
        }
        return Token.chopNumber(Token.token(s1));
    }

    private static byte[] tok(double value) {
        int i;
        if (value == Double.POSITIVE_INFINITY) {
            return INF;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return NINF;
        }
        if (value == 0.0) {
            return 1.0 / value > 0.0 ? ZERO : MZERO;
        }
        if (Double.isNaN(value)) {
            return NAN;
        }
        double a = Math.abs(value);
        if (a < 1000000.0 && (double)(i = (int)value) == value) {
            return Token.token(i);
        }
        return null;
    }

    public static byte[] chopNumber(byte[] token) {
        if (!Token.contains(token, 46) || Token.contains(token, 101) || Token.contains(token, 69)) {
            return token;
        }
        int l = token.length;
        while (--l > 0 && token[l] == 48) {
        }
        return Token.substring(token, 0, token[l] == 46 ? l : l + 1);
    }

    public static double toDouble(byte[] token) {
        int tl = token.length;
        int s = -1;
        while (++s < tl && Token.ws(token[s])) {
        }
        if (s == tl) {
            return Double.NaN;
        }
        int e = s;
        boolean f = false;
        int p = s;
        while (p < tl) {
            byte b = token[p];
            if (e == s) {
                if (!Token.digit(b) && b != 43) {
                    if (Token.ws(b)) {
                        e = p + 1;
                    } else {
                        boolean bl = f = b == 101 || b == 69 || b == 46 || b == 45;
                        if (!f) {
                            return Double.NaN;
                        }
                    }
                }
            } else if (!Token.ws(b)) {
                return Double.NaN;
            }
            ++p;
        }
        if (e == s) {
            e = tl;
        }
        if (f || e - s > 9) {
            return Token.toDouble(token, s, e);
        }
        int d = Token.toInt(token, s, e);
        return d == Integer.MIN_VALUE ? Double.NaN : (double)d;
    }

    private static double toDouble(byte[] token, int start, int end) {
        try {
            return Double.parseDouble(Token.string(token, start, end - start));
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    public static long toLong(byte[] token) {
        return Token.toLong(token, 0, token.length);
    }

    public static long toLong(byte[] token, int start, int end) {
        int p = start;
        while (p < end && Token.ws(token[p])) {
            ++p;
        }
        if (p == end) {
            return Long.MIN_VALUE;
        }
        boolean m = false;
        if (token[p] == 45 || token[p] == 43) {
            boolean bl = m = token[p++] == 45;
        }
        if (p == end) {
            return Long.MIN_VALUE;
        }
        long v = 0L;
        while (p < end) {
            byte b = token[p];
            if (b < 48 || b > 57) break;
            if (v >= 0xCCCCCCCCCCCCCCCL && (b > 55 || v > 0xCCCCCCCCCCCCCCCL)) {
                return Long.MIN_VALUE;
            }
            v = (v << 3) + (v << 1) + (long)b - 48L;
            ++p;
        }
        while (p < end && Token.ws(token[p])) {
            ++p;
        }
        return p < end ? Long.MIN_VALUE : (m ? -v : v);
    }

    public static int toInt(byte[] token) {
        return Token.toInt(token, 0, token.length);
    }

    private static int toInt(byte[] token, int start, int end) {
        int p = start;
        while (p < end && Token.ws(token[p])) {
            ++p;
        }
        if (p == end) {
            return Integer.MIN_VALUE;
        }
        boolean m = false;
        if (token[p] == 45 || token[p] == 43) {
            boolean bl = m = token[p++] == 45;
        }
        if (p == end) {
            return Integer.MIN_VALUE;
        }
        int v = 0;
        while (p < end) {
            byte b = token[p];
            if (b < 48 || b > 57) break;
            if (v >= 0xCCCCCCC && (b > 55 || v > 0xCCCCCCC)) {
                return Integer.MIN_VALUE;
            }
            v = (v << 3) + (v << 1) + b - 48;
            ++p;
        }
        while (p < end && Token.ws(token[p])) {
            ++p;
        }
        return p < end || v < 0 ? Integer.MIN_VALUE : (m ? -v : v);
    }

    public static int hash(byte[] token) {
        int h = 0;
        int l = Math.min(token.length, 96);
        int i = 0;
        while (i != l) {
            h = (h << 5) - h + token[i];
            ++i;
        }
        return h;
    }

    public static boolean eq(byte[] token1, byte[] token2) {
        return Arrays.equals(token1, token2);
    }

    public static boolean eq(byte[] token, byte[] ... tokens) {
        byte[][] byArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] tok = byArray[n2];
            if (Token.eq(token, tok)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static int diff(byte[] token, byte[] compare) {
        int tl = token.length;
        int cl = compare.length;
        int l = Math.min(tl, cl);
        int i = 0;
        while (i < l) {
            int c = (token[i] & 0xFF) - (compare[i] & 0xFF);
            if (c != 0) {
                return c;
            }
            ++i;
        }
        return tl - cl;
    }

    public static byte[] min(byte[] token, byte[] compare) {
        return Token.diff(token, compare) < 0 ? token : compare;
    }

    public static byte[] max(byte[] token, byte[] compare) {
        return Token.diff(token, compare) > 0 ? token : compare;
    }

    public static boolean contains(byte[] token, byte[] sub) {
        return Token.contains(token, sub, 0);
    }

    public static boolean contains(byte[] token, byte[] sub, int pos) {
        return Token.indexOf(token, sub, pos) != -1;
    }

    public static boolean contains(byte[] token, int ch) {
        return Token.indexOf(token, ch) != -1;
    }

    public static int indexOf(byte[] token, int ch) {
        int tl = token.length;
        if (ch < 128) {
            int t = 0;
            while (t < tl) {
                if (token[t] == ch) {
                    return t;
                }
                ++t;
            }
        } else {
            int t = 0;
            while (t < tl) {
                if (Token.cp(token, t) == ch) {
                    return t;
                }
                t += Token.cl(token, t);
            }
        }
        return -1;
    }

    public static int lastIndexOf(byte[] token, int ch) {
        int tl = token.length;
        int p = -1;
        if (ch < 128) {
            int t = tl - 1;
            while (t >= 0) {
                if (token[t] == ch) {
                    return t;
                }
                --t;
            }
        } else {
            int t = 0;
            while (t < tl) {
                if (Token.cp(token, t) == ch) {
                    p = t;
                }
                t += Token.cl(token, t);
            }
        }
        return p;
    }

    public static int indexOf(byte[] token, byte[] sub) {
        return Token.indexOf(token, sub, 0);
    }

    public static int indexOf(byte[] token, byte[] sub, int pos) {
        int sl = sub.length;
        if (sl == 0) {
            return pos;
        }
        int tl = token.length - sl;
        if (pos > tl) {
            return -1;
        }
        int t = pos;
        while (t <= tl) {
            int s = 0;
            while (sub[s] == token[t + s]) {
                if (++s != sl) continue;
                return t;
            }
            ++t;
        }
        return -1;
    }

    public static boolean startsWith(byte[] token, int ch) {
        return Token.startsWith(token, ch, 0);
    }

    private static boolean startsWith(byte[] token, int ch, int pos) {
        return pos < token.length && token[pos] == ch;
    }

    public static boolean startsWith(byte[] token, byte[] sub) {
        return Token.startsWith(token, sub, 0);
    }

    public static boolean startsWith(byte[] token, byte[] sub, int pos) {
        int sl = sub.length;
        if (sl > token.length - pos) {
            return false;
        }
        int s = 0;
        int p = pos;
        while (s < sl) {
            if (sub[s] != token[p]) {
                return false;
            }
            ++s;
            ++p;
        }
        return true;
    }

    public static boolean endsWith(byte[] token, int ch) {
        return token.length != 0 && token[token.length - 1] == ch;
    }

    public static boolean endsWith(byte[] token, byte[] sub) {
        int sl = sub.length;
        int tl = token.length;
        if (sl > tl) {
            return false;
        }
        int s = sl;
        while (s > 0) {
            if (sub[sl - s] != token[tl - s]) {
                return false;
            }
            --s;
        }
        return true;
    }

    public static byte[] substring(byte[] token, int start) {
        return Token.substring(token, start, token.length);
    }

    public static byte[] substring(byte[] token, int start, int end) {
        int s = Math.max(0, start);
        int e = Math.min(end, token.length);
        if (s == 0 && e == token.length) {
            return token;
        }
        return s >= e ? EMPTY : Arrays.copyOfRange(token, s, e);
    }

    public static byte[] subtoken(byte[] token, int start) {
        return Token.subtoken(token, start, token.length);
    }

    public static byte[] subtoken(byte[] token, int start, int end) {
        int s = Math.max(0, start);
        int e = Math.min(end, token.length);
        if (s == 0 && e == token.length) {
            return token;
        }
        if (s >= e) {
            return EMPTY;
        }
        int t = Math.max(0, s - 4);
        while (t != s && t < e) {
            if (t >= s) {
                s = t;
            }
            t += Token.cl(token, t);
        }
        while (t < e) {
            t += Token.cl(token, t);
        }
        return Arrays.copyOfRange(token, s, t);
    }

    public static byte[][] split(byte[] token, int sep) {
        int tl = token.length;
        byte[][] split = new byte[tl][];
        int sl = 0;
        TokenBuilder tb = new TokenBuilder();
        int t = 0;
        while (t < tl) {
            int c = Token.cp(token, t);
            if (c == sep) {
                if (!tb.isEmpty()) {
                    split[sl++] = tb.next();
                }
            } else {
                tb.add(c);
            }
            t += Token.cl(token, t);
        }
        if (!tb.isEmpty()) {
            split[sl++] = tb.finish();
        }
        return Array.copyOf(split, sl);
    }

    public static byte[][] distinctTokens(byte[] token) {
        byte[][] tokens = Token.split(Token.normalize(token), 32);
        int tl = tokens.length;
        int i = 0;
        while (i < tl - 1) {
            int j = i + 1;
            while (j < tl) {
                if (Token.eq(tokens[i], tokens[j])) {
                    Array.move(tokens, j + 1, -1, tl - j - 1);
                    --j;
                    --tl;
                }
                ++j;
            }
            ++i;
        }
        return Array.copyOf(tokens, tl);
    }

    public static boolean ws(byte[] token) {
        byte[] byArray = token;
        int n = token.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (!Token.ws(b)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static byte[] replace(byte[] token, int search, int replace) {
        if (!Token.contains(token, search)) {
            return token;
        }
        TokenBuilder tb = new TokenBuilder(token.length);
        int tl = token.length;
        int i = 0;
        while (i < tl) {
            int c = Token.cp(token, i);
            tb.add(c == search ? replace : c);
            i += Token.cl(token, i);
        }
        return tb.finish();
    }

    public static byte[] trim(byte[] token) {
        int s = -1;
        int e = token.length;
        while (++s < e) {
            if (!Token.ws(token[s])) break;
        }
        while (--e > s) {
            if (!Token.ws(token[e])) break;
        }
        if (++e == token.length && s == 0) {
            return token;
        }
        return s == e ? EMPTY : Arrays.copyOfRange(token, s, e);
    }

    public static byte[] chop(byte[] token, int max) {
        if (token.length <= max) {
            return token;
        }
        byte[] tt = Arrays.copyOf(token, max);
        if (max > 2) {
            tt[max - 3] = 46;
        }
        if (max > 1) {
            tt[max - 2] = 46;
        }
        if (max > 0) {
            tt[max - 1] = 46;
        }
        return tt;
    }

    public static byte[] concat(byte[] token1, byte[] token2) {
        int tl1 = token1.length;
        int tl2 = token2.length;
        byte[] tmp = new byte[tl1 + tl2];
        System.arraycopy(token1, 0, tmp, 0, tl1);
        System.arraycopy(token2, 0, tmp, tl1, tl2);
        return tmp;
    }

    public static byte[] concat(byte[] token1, byte[] token2, byte[] token3) {
        int tl1 = token1.length;
        int tl2 = token2.length;
        int tl3 = token3.length;
        byte[] tmp = new byte[tl1 + tl2 + tl3];
        System.arraycopy(token1, 0, tmp, 0, tl1);
        System.arraycopy(token2, 0, tmp, tl1, tl2);
        System.arraycopy(token3, 0, tmp, tl1 + tl2, tl3);
        return tmp;
    }

    public static byte[] delete(byte[] token, int ch) {
        if (ch < 128) {
            if (!Token.contains(token, ch)) {
                return token;
            }
            int tl = token.length;
            TokenBuilder tb = new TokenBuilder(tl);
            byte[] byArray = token;
            int n = token.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if (b != ch) {
                    tb.add(b);
                }
                ++n2;
            }
            return tb.finish();
        }
        int tl = token.length;
        TokenBuilder tb = new TokenBuilder(tl);
        int i = 0;
        while (i < tl) {
            int c = Token.cp(token, i);
            if (c != ch) {
                tb.add(c);
            }
            i += Token.cl(token, i);
        }
        return tb.finish();
    }

    public static byte[] normalize(byte[] token) {
        int l = token.length;
        if (l == 0) {
            return token;
        }
        byte[] tmp = new byte[l];
        int c = 0;
        boolean ws1 = true;
        byte[] byArray = token;
        int n = token.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            boolean ws2 = Token.ws(b);
            if (!ws2 || !ws1) {
                tmp[c++] = ws2 ? 32 : b;
                ws1 = ws2;
            }
            ++n2;
        }
        if (c > 0 && Token.ws(tmp[c - 1])) {
            --c;
        }
        return c == l ? tmp : Arrays.copyOf(tmp, c);
    }

    public static boolean ws(int ch) {
        return ch == 9 || ch == 10 || ch == 13 || ch == 32;
    }

    public static boolean letter(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 95;
    }

    public static boolean digit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    public static boolean letterOrDigit(int ch) {
        return Token.letter(ch) || Token.digit(ch);
    }

    public static byte[] uc(byte[] token) {
        if (Token.ascii(token)) {
            int tl = token.length;
            byte[] tok = new byte[tl];
            int t = 0;
            while (t < tl) {
                tok[t] = (byte)Token.uc(token[t]);
                ++t;
            }
            return tok;
        }
        return Token.token(Token.string(token).toUpperCase(Locale.ENGLISH));
    }

    public static byte[] tc(byte[] token) {
        int tl = token.length;
        TokenBuilder tb = new TokenBuilder(tl);
        boolean del = false;
        int t = 0;
        while (t < tl) {
            int cp = Token.cp(token, t);
            tb.add(del ? Token.lc(cp) : Token.uc(cp));
            del = Character.isLetterOrDigit(cp);
            t += Token.cl(token, t);
        }
        return tb.finish();
    }

    public static int uc(int ch) {
        return ch >= 97 && ch <= 122 ? ch - 32 : (ch > 127 ? Character.toUpperCase(ch) : ch);
    }

    public static byte[] lc(byte[] token) {
        if (Token.ascii(token)) {
            int tl = token.length;
            byte[] tok = new byte[tl];
            int t = 0;
            while (t < tl) {
                tok[t] = (byte)Token.lc(token[t]);
                ++t;
            }
            return tok;
        }
        return Token.token(Token.string(token).toLowerCase(Locale.ENGLISH));
    }

    public static int lc(int ch) {
        return ch >= 65 && ch <= 90 ? ch | 0x20 : (ch > 127 ? Character.toLowerCase(ch) : ch);
    }

    public static byte[] prefix(byte[] name) {
        int i = Token.indexOf(name, 58);
        return i == -1 ? EMPTY : Token.substring(name, 0, i);
    }

    public static byte[] local(byte[] name) {
        int i = Token.indexOf(name, 58);
        return i == -1 ? name : Token.substring(name, i + 1);
    }

    public static byte[] encodeUri(byte[] token, boolean iri) {
        TokenBuilder tb = new TokenBuilder();
        byte[] byArray = token;
        int n = token.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (Token.letterOrDigit(b) || Token.contains(iri ? IRIRES : RES, b)) {
                tb.addByte(b);
            } else {
                Token.hex(tb, b);
            }
            ++n2;
        }
        return tb.finish();
    }

    public static byte[] escape(byte[] token) {
        TokenBuilder tb = new TokenBuilder();
        byte[] byArray = token;
        int n = token.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b >= 32 && b <= 126) {
                tb.addByte(b);
            } else {
                Token.hex(tb, b);
            }
            ++n2;
        }
        return tb.finish();
    }

    private static void hex(TokenBuilder tb, byte value) {
        tb.add(37);
        tb.addByte(HEX[(value & 0xFF) >> 4]);
        tb.addByte(HEX[value & 0xFF & 0xF]);
    }

    public static byte[] hex(byte[] value, boolean uc) {
        int vl = value.length;
        int u = uc ? 55 : 87;
        byte[] data = new byte[vl << 1];
        int v = 0;
        int c = 0;
        while (v < vl) {
            int b = value[v] >> 4 & 0xF;
            data[c++] = (byte)(b + (b > 9 ? u : 48));
            b = value[v] & 0xF;
            data[c++] = (byte)(b + (b > 9 ? u : 48));
            ++v;
        }
        return data;
    }

    public static int dec(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70) {
            return (ch & 0xF) + 9;
        }
        return -1;
    }

    public static int dec(int ch1, int ch2) {
        int n1 = Token.dec(ch1);
        int n2 = Token.dec(ch2);
        return n1 < 0 || n2 < 0 ? -1 : n1 << 4 | n2;
    }

    public static byte[] decodeUri(byte[] token) {
        if (!Token.contains(token, 37)) {
            return token;
        }
        int tl = token.length;
        TokenBuilder tb = new TokenBuilder(tl);
        int t = 0;
        while (t < tl) {
            byte b = token[t];
            if (b == 37) {
                int n;
                int n2 = n = t + 2 < tl ? Token.dec(token[t + 1], token[t + 2]) : -1;
                if (n < 0) {
                    return null;
                }
                b = (byte)n;
                t += 2;
            }
            tb.addByte(b);
            ++t;
        }
        return tb.finish();
    }
}

