/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import java.util.Objects;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.io.in.TextInput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.Function;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Lazy;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class StrLazy
extends AStr
implements Lazy {
    private final IO input;
    private final String encoding;
    private final QueryError error;
    private final boolean validate;

    public StrLazy(IO input, String encoding, QueryError error, boolean validate) {
        this.input = input;
        this.encoding = encoding;
        this.error = error;
        this.validate = validate;
    }

    @Override
    public byte[] string(InputInfo info) throws QueryException {
        this.materialize(info);
        return this.value;
    }

    @Override
    public String toJava() throws QueryException {
        return Token.string(this.string(null));
    }

    @Override
    public BufferInput input(InputInfo info) throws QueryException {
        if (this.isCached()) {
            return super.input(info);
        }
        TextInput ti = null;
        try {
            ti = new TextInput(this.input);
            ti.encoding(this.encoding).validate(this.validate);
            return ti;
        }
        catch (IOException ex) {
            if (ti != null) {
                try {
                    ti.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw this.error.get(info, ex);
        }
    }

    @Override
    public void materialize(InputInfo info) throws QueryException {
        try {
            if (!this.isCached()) {
                this.value = this.input(info).content();
            }
        }
        catch (IOException ex) {
            throw this.error.get(info, ex);
        }
    }

    @Override
    public boolean isCached() {
        return this.value != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StrLazy) {
            StrLazy s = (StrLazy)obj;
            if (this.input.eq(s.input) && Objects.equals(this.encoding, s.encoding) && this.error == s.error && this.validate == s.validate) {
                return true;
            }
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return this.isCached() ? StrLazy.toString(this.value) : Function._FILE_READ_TEXT.args(this.input).substring(1);
    }
}

