/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Bln
extends Item {
    public static final Bln TRUE = new Bln(true);
    public static final Bln FALSE = new Bln(false);
    private final boolean value;

    private Bln(boolean value) {
        super(AtomType.BLN);
        this.value = value;
    }

    private Bln(boolean value, double score) {
        this(value);
        this.score = score;
    }

    public static Bln get(boolean value, double score) {
        return value && score != 0.0 ? new Bln(true, score) : Bln.get(value);
    }

    public static Bln get(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public byte[] string(InputInfo info) {
        return Token.token(this.value);
    }

    @Override
    public boolean bool(InputInfo info) {
        return this.value;
    }

    @Override
    public long itr(InputInfo info) {
        return this.value ? 1 : 0;
    }

    @Override
    public float flt(InputInfo info) {
        return this.value ? 1 : 0;
    }

    @Override
    public double dbl(InputInfo info) {
        return this.value ? 1 : 0;
    }

    @Override
    public BigDecimal dec(InputInfo info) {
        return this.value ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
        return this.value == (item.type == this.type ? item.bool(info) : Bln.parse(item, info));
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        boolean n;
        boolean bl = n = item.type == this.type ? item.bool(info) : Bln.parse(item, info);
        return this.value ? (n ? 0 : 1) : (n ? -1 : 0);
    }

    @Override
    public Boolean toJava() {
        return this.value;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Bln && this.value == ((Bln)obj).value;
    }

    @Override
    public String toString() {
        return new TokenBuilder(this.value ? Token.TRUE : Token.FALSE).add("()").toString();
    }

    public static boolean parse(Item item, InputInfo info) throws QueryException {
        Boolean b = Bln.parse(item.string(info));
        if (b != null) {
            return b;
        }
        throw AtomType.BLN.castError(item, info);
    }

    public static Boolean parse(byte[] value) {
        byte[] v = Token.trim(value);
        if (Token.eq(v, Token.TRUE) || Token.eq(v, Token.ONE)) {
            return Boolean.TRUE;
        }
        if (Token.eq(v, Token.FALSE) || Token.eq(v, Token.ZERO)) {
            return Boolean.FALSE;
        }
        return null;
    }
}

