/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.regex.parse;

public class TokenMgrError
extends Error {
    private static final long serialVersionUID = 1L;
    static final int LEXICAL_ERROR = 0;
    static final int STATIC_LEXER_ERROR = 1;
    static final int INVALID_LEXICAL_STATE = 2;
    static final int LOOP_DETECTED = 3;
    int errorCode;

    protected static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }

    protected static String lexicalError(boolean eof, int state, int line, int col, String after, char curr) {
        return "Lexical error at line " + line + ", column " + col + ".  Encountered: " + (eof ? "<EOF> " : String.valueOf('\"') + TokenMgrError.addEscapes(String.valueOf(curr)) + '\"' + " (" + curr + "), ") + "after : \"" + TokenMgrError.addEscapes(after) + '\"';
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public TokenMgrError() {
    }

    public TokenMgrError(String message, int reason) {
        super(message);
        this.errorCode = reason;
    }

    public TokenMgrError(boolean eof, int state, int line, int col, String after, char curr, int reason) {
        this(TokenMgrError.lexicalError(eof, state, line, col, after, curr), reason);
    }
}

