/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.regex.parse;

import org.basex.query.util.regex.parse.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token curr, int[][] exps, String[] imgs) {
        super(ParseException.initialise(curr, exps, imgs));
        this.currentToken = curr;
        this.expectedTokenSequences = exps;
        this.tokenImage = imgs;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token curr, int[][] exps, String[] img) {
        String eol = System.getProperty("line.separator", "\n");
        StringBuilder expected = new StringBuilder();
        int maxSize = 0;
        int[][] nArray = exps;
        int n = exps.length;
        int n2 = 0;
        while (n2 < n) {
            int[] exp = nArray[n2];
            if (maxSize < exp.length) {
                maxSize = exp.length;
            }
            int[] nArray2 = exp;
            int n3 = exp.length;
            int n4 = 0;
            while (n4 < n3) {
                int ex = nArray2[n4];
                expected.append(img[ex]).append(' ');
                ++n4;
            }
            if (exp[exp.length - 1] != 0) {
                expected.append("...");
            }
            expected.append(eol).append("    ");
            ++n2;
        }
        String retval = "Encountered \"";
        Token tok = curr.next;
        int i = 0;
        while (i < maxSize) {
            if (i != 0) {
                retval = String.valueOf(retval) + " ";
            }
            if (tok.kind == 0) {
                retval = String.valueOf(retval) + img[0];
                break;
            }
            retval = String.valueOf(retval) + ' ' + img[tok.kind];
            retval = String.valueOf(retval) + " \"";
            retval = String.valueOf(retval) + ParseException.addEscapes(tok.image);
            retval = String.valueOf(retval) + " \"";
            tok = tok.next;
            ++i;
        }
        retval = String.valueOf(retval) + "\" at line " + curr.next.beginLine + ", column " + curr.next.beginColumn;
        retval = String.valueOf(retval) + '.' + eol;
        retval = exps.length == 1 ? String.valueOf(retval) + "Was expecting:" + eol + "    " : String.valueOf(retval) + "Was expecting one of:" + eol + "    ";
        retval = String.valueOf(retval) + expected.toString();
        return retval;
    }

    static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

