/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.util.NSGlobal;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class NSContext {
    public final Atts ns = new Atts();
    private Atts stack;

    public void add(byte[] pref, byte[] uri, InputInfo info) throws QueryException {
        if (Token.eq(pref, Token.XML, Token.XMLNS)) {
            throw QueryError.BINDXML_X.get(info, new Object[]{pref});
        }
        if (Token.eq(uri, QueryText.XML_URI)) {
            throw QueryError.BINDXMLURI_X_X.get(info, uri, Token.XML);
        }
        if (Token.eq(uri, QueryText.XMLNS_URI)) {
            throw QueryError.BINDXMLURI_X_X.get(info, uri, Token.XMLNS);
        }
        this.ns.add(pref, uri);
    }

    public void delete(byte[] pref) {
        int s = this.ns.size() - 1;
        while (s >= 0) {
            if (Token.eq(pref, this.ns.name(s))) {
                this.ns.delete(s);
            }
            --s;
        }
    }

    public byte[] staticURI(byte[] pref) {
        int s = this.ns.size() - 1;
        while (s >= 0) {
            if (Token.eq(this.ns.name(s), pref)) {
                return this.ns.value(s);
            }
            --s;
        }
        return null;
    }

    public byte[] uri(byte[] pref) {
        byte[] u;
        if (this.stack != null) {
            int s = this.stack.size() - 1;
            while (s >= 0) {
                if (Token.eq(this.stack.name(s), pref)) {
                    return this.stack.value(s);
                }
                --s;
            }
        }
        return (u = this.staticURI(pref)) == null ? (pref.length == 0 ? null : NSGlobal.uri(pref)) : (u.length == 0 ? null : u);
    }

    public int size() {
        return this.stack().size();
    }

    public void size(int s) {
        this.stack().size(s);
    }

    public void add(byte[] pref, byte[] uri) {
        this.stack().add(pref, uri);
    }

    public Atts stack() {
        if (this.stack == null) {
            this.stack = new Atts();
        }
        return this.stack;
    }

    public void inScope(Atts atts) {
        if (this.stack != null) {
            int s = this.stack.size() - 1;
            while (s >= 0) {
                byte[] nm = this.stack.name(s);
                if (!atts.contains(nm)) {
                    atts.add(nm, this.stack.value(s));
                }
                --s;
            }
        }
    }
}

