/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.node;

import java.util.LinkedList;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.NamePool;
import org.basex.query.up.atomic.AtomicUpdateCache;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.node.DeleteNode;
import org.basex.query.up.primitives.node.NodeUpdate;
import org.basex.query.up.primitives.node.ReplaceContent;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class ReplaceValue
extends NodeUpdate {
    private final byte[] value;
    public final boolean rec;

    public ReplaceValue(int pre, Data data, InputInfo ii, byte[] value) {
        super(UpdateType.REPLACEVALUE, pre, data, ii);
        this.value = value;
        this.rec = data.kind(pre) == 1;
    }

    @Override
    public void prepare(MemData tmp, QueryContext qc) {
    }

    @Override
    public void merge(Update update) throws QueryException {
        throw QueryError.UPMULTREPV_X.get(this.info, this.node());
    }

    @Override
    public int size() {
        return 1;
    }

    public String toString() {
        return Util.info("%[%, %]", Util.className(this), this.node(), this.value);
    }

    private boolean deleteText() {
        return this.value.length == 0 && this.data.kind(this.pre) == 2;
    }

    private boolean substituted() {
        return this.rec || this.deleteText();
    }

    @Override
    public void addAtomics(AtomicUpdateCache auc) {
        if (!this.substituted()) {
            auc.addUpdateValue(this.pre, this.value);
        }
    }

    @Override
    public NodeUpdate[] substitute(MemData tmp) {
        int k = this.data.kind(this.pre);
        if (this.rec) {
            LinkedList<NodeUpdate> l = new LinkedList<NodeUpdate>();
            l.add(this);
            int firstChild = this.pre + this.data.attSize(this.pre, k);
            int followingNode = this.pre + this.data.size(this.pre, k);
            int runner = firstChild;
            while (runner < followingNode) {
                l.add(new DeleteNode(runner, this.data, this.info, true));
                runner += this.data.size(runner, this.data.kind(runner));
            }
            if (this.value.length > 0) {
                int p = tmp.meta.size;
                tmp.text(1, this.value, 2);
                tmp.insert(p);
                ANodeList nl = new ANodeList(new ANode[]{new DBNode(tmp, p)});
                l.add(new ReplaceContent(this.pre, this.data, this.info, nl));
            }
            return l.toArray(new NodeUpdate[l.size()]);
        }
        if (this.deleteText()) {
            return new NodeUpdate[]{this, new DeleteNode(this.pre, this.data, this.info, false)};
        }
        return new NodeUpdate[]{this};
    }

    @Override
    public void update(NamePool pool) {
    }
}

