/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.db;

import org.basex.core.cmd.Delete;
import org.basex.data.Data;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class DBDelete
extends DBUpdate {
    private final StringList paths = new StringList(1);
    private int size;

    public DBDelete(Data data, String path, InputInfo info) {
        super(UpdateType.DBDELETE, data, info);
        this.paths.add(path);
        this.size = data.resources.binaries(path).size();
    }

    @Override
    public void merge(Update update) {
        for (String path : ((DBDelete)update).paths) {
            this.paths.add(path);
        }
        this.size += update.size();
    }

    @Override
    public void apply() {
        for (String path : this.paths) {
            Delete.delete(this.data, path);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void prepare() {
    }
}

