/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Transform
extends Arr {
    private final Let[] copies;

    public Transform(InputInfo info, Let[] copies, Expr mod, Expr ret) {
        super(info, SeqType.ITEM_ZM, mod, ret);
        this.copies = copies;
    }

    @Override
    public void checkUp() throws QueryException {
        Let[] letArray = this.copies;
        int n = this.copies.length;
        int n2 = 0;
        while (n2 < n) {
            Let copy = letArray[n2];
            copy.checkUp();
            ++n2;
        }
        Expr modify = this.exprs[0];
        modify.checkUp();
        if (!modify.isVacuous() && !modify.has(Flag.UPD)) {
            throw QueryError.UPMODIFY.get(this.info, new Object[0]);
        }
        this.exprs[1].checkUp();
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        Let[] letArray = this.copies;
        int n = this.copies.length;
        int n2 = 0;
        while (n2 < n) {
            Let copy = letArray[n2];
            copy.expr = copy.expr.compile(cc);
            ++n2;
        }
        return super.compile(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        Let[] letArray = this.copies;
        int n = this.copies.length;
        int n2 = 0;
        while (n2 < n) {
            Let copy = letArray[n2];
            copy.adoptType(copy.expr);
            ++n2;
        }
        return this.adoptType(this.exprs[1]);
    }

    @Override
    public BasicIter<?> iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Updates updates;
        Updates upd = qc.updates();
        qc.updates = updates = new Updates(true);
        try {
            Let[] letArray = this.copies;
            int n = this.copies.length;
            int n2 = 0;
            while (n2 < n) {
                Let copy = letArray[n2];
                Iter iter = copy.expr.iter(qc);
                Item item = iter.next();
                if (!(item instanceof ANode)) {
                    throw QueryError.UPSINGLE_X_X.get(copy.info, copy.var.name, item == null ? Empty.SEQ : item);
                }
                Item i2 = iter.next();
                if (i2 != null) {
                    throw QueryError.UPSINGLE_X_X.get(copy.info, copy.var.name, ValueBuilder.concat(item, i2, qc));
                }
                item = ((ANode)item).dbNodeCopy(qc.context.options, qc);
                qc.set(copy.var, item);
                updates.addData(item.data());
                ++n2;
            }
            Value value = this.exprs[0].value(qc);
            if (!value.isEmpty()) {
                throw QueryError.UPMODIFY.get(this.info, new Object[0]);
            }
            updates.prepare(qc);
            updates.apply(qc);
        }
        finally {
            qc.updates = upd;
        }
        return this.exprs[1].value(qc);
    }

    @Override
    public boolean has(Flag ... flags) {
        Let[] letArray = this.copies;
        int n = this.copies.length;
        int n2 = 0;
        while (n2 < n) {
            Let copy = letArray[n2];
            if (copy.has(flags)) {
                return true;
            }
            ++n2;
        }
        if (Flag.UPD.in(flags) && this.exprs[1].has(Flag.UPD)) {
            return true;
        }
        Flag[] flgs = Flag.UPD.remove(flags);
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public boolean removable(Var var) {
        Let[] letArray = this.copies;
        int n = this.copies.length;
        int n2 = 0;
        while (n2 < n) {
            Let copy = letArray[n2];
            if (!copy.removable(var)) {
                return false;
            }
            ++n2;
        }
        return super.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.copies).plus(super.count(var));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = Transform.inlineAll(this.copies, var, ex, cc);
        return Transform.inlineAll(this.exprs, var, ex, cc) || changed ? this.optimize(cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Transform(this.info, (Let[])Transform.copyAll((CompileContext)cc, vm, (Expr[])this.copies), this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm)));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return Transform.visitAll(visitor, this.copies) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = 1;
        Expr[] exprArray = this.copies;
        int n = this.copies.length;
        int n2 = 0;
        while (n2 < n) {
            Let copy = exprArray[n2];
            size += copy.exprSize();
            ++n2;
        }
        exprArray = this.exprs;
        n = this.exprs.length;
        n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            size += expr.exprSize();
            ++n2;
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Transform && Array.equals(this.copies, ((Transform)obj).copies) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        Transform.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.copies, this.exprs});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("copy ");
        Let[] letArray = this.copies;
        int n = this.copies.length;
        int n2 = 0;
        while (n2 < n) {
            Let copy = letArray[n2];
            sb.append(copy.var).append(' ').append(":=").append(' ').append(copy.expr).append(' ');
            ++n2;
        }
        return sb.append("modify ").append(this.exprs[0]).append(' ').append("return").append(' ').append(this.exprs[1]).toString();
    }
}

