/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.DataUpdates;
import org.basex.query.up.NameUpdates;
import org.basex.query.up.UserUpdates;
import org.basex.query.up.primitives.DataUpdate;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UserUpdate;
import org.basex.query.up.primitives.name.NameUpdate;
import org.basex.util.Util;
import org.basex.util.list.StringList;

abstract class ContextModifier {
    private final Map<Data, DataUpdates> dbUpdates = new HashMap<Data, DataUpdates>();
    private final Map<String, NameUpdates> nameUpdates = new HashMap<String, NameUpdates>();
    private final Map<String, UserUpdates> userUpdates = new HashMap<String, UserUpdates>();
    private MemData memData;

    ContextModifier() {
    }

    abstract void addData(Data var1);

    synchronized void add(Update update, QueryContext qc) throws QueryException {
        if (update instanceof DataUpdate) {
            if (this.memData == null) {
                this.memData = new MemData(qc.context.options);
            }
            DataUpdate dataUp = (DataUpdate)update;
            this.dbUpdates.computeIfAbsent(dataUp.data(), d -> new DataUpdates((Data)d, qc)).add(dataUp, this.memData);
        } else if (update instanceof NameUpdate) {
            NameUpdate nameUp = (NameUpdate)update;
            this.nameUpdates.computeIfAbsent(nameUp.name(), n -> new NameUpdates()).add(nameUp);
        } else if (update instanceof UserUpdate) {
            UserUpdate userUp = (UserUpdate)update;
            this.userUpdates.computeIfAbsent(userUp.name(), n -> new UserUpdates()).add(userUp);
        } else {
            throw Util.notExpected("Unknown update type: " + update, new Object[0]);
        }
    }

    synchronized void databases(StringList db) {
        for (Data data : this.dbUpdates.keySet()) {
            if (data.inMemory()) continue;
            db.add(data.meta.name);
        }
        for (NameUpdates up : this.nameUpdates.values()) {
            up.databases(db);
        }
    }

    final synchronized void prepare(HashSet<Data> datas, QueryContext qc) throws QueryException {
        for (DataUpdates dataUpdates : this.dbUpdates.values()) {
            if (this.memData == null) {
                this.memData = new MemData(qc.context.options);
            }
            dataUpdates.prepare(this.memData, qc);
            datas.add(dataUpdates.data());
        }
        for (NameUpdates nameUpdates : this.nameUpdates.values()) {
            nameUpdates.prepare();
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    final synchronized void apply(QueryContext qc) throws QueryException {
        ctx = qc.context;
        for (Object up : this.userUpdates.values()) {
            up.apply();
        }
        if (!this.userUpdates.isEmpty()) {
            ctx.users.write(ctx);
        }
        for (Object up : this.nameUpdates.values()) {
            up.apply(true);
        }
        datas = new HashSet<Data>();
        try {
            try {
                for (Data data : this.dbUpdates.keySet()) {
                    data.startUpdate(ctx.options);
                    datas.add(data);
                }
                for (Object up : this.dbUpdates.values()) {
                    up.apply(qc);
                }
            }
            catch (IOException ex) {
                throw QueryError.DB_LOCK2_X.get(null, new Object[]{ex});
            }
        }
        finally {
            ** for (data : datas)
        }
lbl-1000:
        // 1 sources

        {
            data.finishUpdate(ctx.options);
            continue;
        }
lbl28:
        // 2 sources

        for (Object up : this.nameUpdates.values()) {
            up.apply(false);
        }
    }

    final synchronized int size() {
        int size = 0;
        for (DataUpdates dataUpdates : this.dbUpdates.values()) {
            size += dataUpdates.size();
        }
        for (NameUpdates nameUpdates : this.nameUpdates.values()) {
            size += nameUpdates.size();
        }
        for (UserUpdates userUpdates : this.userUpdates.values()) {
            size += userUpdates.size();
        }
        return size;
    }
}

