/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.scope;

import java.util.IdentityHashMap;
import org.basex.core.locks.LockList;
import org.basex.core.locks.Locks;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.iter.Iter;
import org.basex.query.scope.Module;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.TokenSet;

public final class MainModule
extends Module {
    private final SeqType declType;

    public static MainModule get(VarScope vs, Expr expr, SeqType declType, String doc, InputInfo info) {
        return new MainModule(vs, expr, declType, doc, info, null, null, null);
    }

    public static MainModule get(StaticFunc sf, Expr[] args) throws QueryException {
        StaticFuncCall expr = new StaticFuncCall(sf.name, args, sf.sc, sf.info).init(sf);
        return new MainModule(new VarScope(sf.sc), expr, null, null, null, null, null, null);
    }

    public MainModule(VarScope vs, Expr expr, SeqType declType, String doc, InputInfo info, TokenObjMap<StaticFunc> funcs, TokenObjMap<StaticVar> vars, TokenSet imports) {
        super(vs.sc, vs, doc, info, funcs, vars, imports);
        this.expr = expr;
        this.declType = declType;
    }

    @Override
    public void comp(CompileContext cc) throws QueryException {
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        cc.pushScope(this.vs);
        try {
            this.expr = this.expr.compile(cc);
        }
        finally {
            cc.removeScope(this);
        }
    }

    public ItemList cache(QueryContext qc) throws QueryException {
        int fp = this.vs.enter(qc);
        try {
            Item item;
            Iter iter = this.expr.iter(qc);
            ItemList items = new ItemList(iter.size());
            while ((item = qc.next(iter)) != null) {
                items.add(item);
            }
            if (this.declType != null) {
                this.declType.treat(items.value(), null, this.info, qc);
            }
            ItemList itemList = items;
            return itemList;
        }
        finally {
            VarScope.exit(fp, qc);
        }
    }

    public Iter iter(final QueryContext qc) throws QueryException {
        if (this.declType != null) {
            return this.cache(qc).iter();
        }
        final int fp = this.vs.enter(qc);
        final Iter iter = this.expr.iter(qc);
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item item = qc.next(iter);
                if (item == null) {
                    VarScope.exit(fp, qc);
                }
                return item;
            }

            @Override
            public long size() throws QueryException {
                return iter.size();
            }

            @Override
            public Item get(long i) throws QueryException {
                return iter.get(i);
            }

            @Override
            public Value value(QueryContext q) throws QueryException {
                return iter.value(qc);
            }
        };
    }

    @Override
    public String toString() {
        return this.expr.toString();
    }

    @Override
    public void plan(FElem e) {
        this.expr.plan(e);
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        return this.expr.accept(visitor);
    }

    public boolean databases(Locks lr, QueryContext qc) {
        return this.expr.accept(new LockVisitor(lr, qc));
    }

    private static final class LockVisitor
    extends ASTVisitor {
        private final IdentityHashMap<Scope, Object> funcs = new IdentityHashMap();
        private final LockList locks;
        private int level;

        private LockVisitor(Locks lr, QueryContext qc) {
            this.locks = qc.updating ? lr.writes : lr.reads;
            this.level = qc.ctxItem == null ? 0 : 1;
        }

        @Override
        public boolean lock(String db) {
            if (db == null) {
                return false;
            }
            if (this.level == 0 || db != "%CONTEXT") {
                this.locks.add(db);
            }
            return true;
        }

        @Override
        public void enterFocus() {
            ++this.level;
        }

        @Override
        public void exitFocus() {
            --this.level;
        }

        @Override
        public boolean staticVar(StaticVar var) {
            if (this.funcs.containsKey(var)) {
                return true;
            }
            this.funcs.put(var, null);
            return var.visit(this);
        }

        @Override
        public boolean staticFuncCall(StaticFuncCall call) {
            return this.func(call.func());
        }

        @Override
        public boolean inlineFunc(Scope scope) {
            this.enterFocus();
            boolean ac = scope.visit(this);
            this.exitFocus();
            return ac;
        }

        @Override
        public boolean funcItem(FuncItem func) {
            return this.func(func);
        }

        private boolean func(Scope scp) {
            if (this.funcs.containsKey(scp)) {
                return true;
            }
            this.funcs.put(scp, null);
            this.enterFocus();
            boolean ac = scp.visit(this);
            this.exitFocus();
            return ac;
        }
    }
}

