/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.zip;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.zip.ZipFn;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class ZipEntries
extends ZipFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        String file = Token.string(this.toToken(this.exprs[0], qc));
        IOFile path = new IOFile(file);
        if (!path.exists()) {
            throw QueryError.ZIP_NOTFOUND_X.get(this.info, file);
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ZipFile zf = new ZipFile(file);){
                FElem root = new FElem(Q_FILE).declareNS().add(HREF, path.path());
                ZipEntries.createEntries(ZipEntries.paths(zf).iterator(), root, "");
                return root;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw QueryError.ZIP_FAIL_X.get(this.info, ex);
        }
    }

    private static String createEntries(Iterator<String> it, FElem par, String pref) {
        String path = null;
        boolean curr = false;
        while (curr || it.hasNext()) {
            if (!curr) {
                path = it.next();
                curr = true;
            }
            if (path == null) break;
            if (!path.startsWith(pref)) {
                return path;
            }
            int i = path.lastIndexOf(47);
            String dir = i == -1 ? path : path.substring(0, i);
            String name = path.substring(i + 1);
            if (name.isEmpty()) {
                path = ZipEntries.createEntries(it, ZipEntries.createDir(par, dir), dir);
                continue;
            }
            ZipEntries.createFile(par, name);
            curr = false;
        }
        return null;
    }

    private static FElem createDir(FElem par, String name) {
        FElem elem = new FElem(Q_DIR).add(NAME, name);
        par.add(elem);
        return elem;
    }

    private static void createFile(FElem par, String name) {
        par.add(new FElem(Q_ENTRY).add(NAME, name));
    }

    private static StringList paths(ZipFile zf) {
        TreeSet<String> paths = new TreeSet<String>();
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            String name = ze.getName();
            int i = name.lastIndexOf(47);
            if (i > -1 && i + 1 < name.length()) {
                paths.add(name.substring(0, i + 1));
            }
            paths.add(name);
        }
        StringList sl = new StringList();
        for (String path : paths) {
            sl.add(path);
        }
        return sl;
    }
}

