/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.zip;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.zip.ZipFn;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public class ZipBinaryEntry
extends ZipFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return B64.get(this.entry(qc));
    }

    final byte[] entry(QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        IOFile file = new IOFile(Token.string(this.toToken(this.exprs[0], qc)));
        String path = Token.string(this.toToken(this.exprs[1], qc));
        if (!file.exists()) {
            throw QueryError.ZIP_NOTFOUND_X.get(this.info, file);
        }
        try {
            return new Zip(file).read(path);
        }
        catch (FileNotFoundException ex) {
            Util.debug(ex);
            throw QueryError.ZIP_NOTFOUND_X.get(this.info, file + "/" + path);
        }
        catch (IOException ex) {
            throw QueryError.ZIP_FAIL_X.get(this.info, ex);
        }
    }
}

