/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.user;

import org.basex.core.users.User;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.user.UserFn;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.UserUpdate;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Strings;

public final class UserAlter
extends UserFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        this.checkAdmin(qc);
        User user = this.toSafeUser(0, qc);
        String name = user.name();
        String newname = this.toSafeName(1, qc);
        if (Strings.eq("admin", name, newname)) {
            throw QueryError.USER_ADMIN.get(this.info, new Object[0]);
        }
        if (Strings.eq(name, newname)) {
            throw QueryError.USER_EQUAL_X.get(this.info, name);
        }
        qc.updates().add(new Alter(user, newname, qc, this.info), qc);
        return null;
    }

    private static final class Alter
    extends UserUpdate {
        private final String newname;

        private Alter(User user, String newname, QueryContext qc, InputInfo info) {
            super(UpdateType.USERALTER, user, qc, info);
            this.newname = newname;
        }

        @Override
        public void apply() {
            User old = this.users.get(this.newname);
            if (old != null) {
                this.users.drop(old);
            }
            this.users.alter(this.user, this.newname);
        }

        @Override
        public String operation() {
            return "altered";
        }
    }
}

