/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.random;

import java.util.Random;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;

public final class RandomSeededInteger
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        long max;
        long seed = this.toLong(this.exprs[0], qc);
        final long num = this.toLong(this.exprs[1], qc);
        if (num < 0L) {
            throw QueryError.RANGE_NEGATIVE_X.get(this.info, num);
        }
        long l = max = this.exprs.length > 2 ? this.toLong(this.exprs[2], qc) : Integer.MAX_VALUE;
        if (max < 1L || max > Integer.MAX_VALUE) {
            throw QueryError.RANDOM_BOUNDS_X.get(this.info, max);
        }
        return new Iter(seed){
            final Random r;
            long c;
            {
                this.r = new Random(l);
            }

            @Override
            public Item next() {
                return ++this.c <= num ? Int.get(max == Integer.MAX_VALUE ? this.r.nextInt() : this.r.nextInt((int)max)) : null;
            }
        };
    }
}

