/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.Prop;
import org.basex.util.Token;

public class FileWriteTextLines
extends FileFn {
    private static final byte[] NL = Token.token(Prop.NL);

    @Override
    public Item item(QueryContext qc) throws IOException, QueryException {
        return this.write(false, qc);
    }

    final synchronized Item write(boolean append, QueryContext qc) throws QueryException, IOException {
        Path path = this.checkParentDir(this.toPath(0, qc));
        Value value = this.exprs[1].value(qc);
        String enc = this.toEncoding(2, QueryError.FILE_UNKNOWN_ENCODING_X, qc);
        Charset cs = enc == null || enc == "UTF-8" ? null : Charset.forName(enc);
        Throwable throwable = null;
        Object var8_9 = null;
        try (PrintOutput out = PrintOutput.get(new FileOutputStream(path.toFile(), append));){
            for (Item item : value) {
                if (!item.type.isStringOrUntyped()) {
                    throw QueryError.typeError(item, AtomType.STR, this.info);
                }
                byte[] s = item.string(this.info);
                out.write(cs == null ? s : Token.string(s).getBytes(cs));
                out.write(cs == null ? NL : Prop.NL.getBytes(cs));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }
}

