/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileRead;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.list.TokenList;

public final class FileChildren
extends FileRead {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        try {
            TokenList tl = new TokenList();
            Throwable throwable = null;
            Object var4_8 = null;
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(this.toPath(0, qc));){
                for (Path path : paths) {
                    tl.add(FileChildren.get(path, Files.isDirectory(path, new LinkOption[0])).string());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return StrSeq.get(tl);
        }
        catch (NoSuchFileException | NotDirectoryException ex) {
            throw QueryError.FILE_NO_DIR_X.get(this.info, ex);
        }
        catch (AccessDeniedException ex) {
            throw QueryError.FILE_IE_ERROR_ACCESS_X.get(this.info, ex);
        }
        catch (IOException ex) {
            throw QueryError.FILE_IO_ERROR_X.get(this.info, ex);
        }
    }
}

