/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Test;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class NodeTest
extends Test {
    private final Type ext;

    public NodeTest(QNm name) {
        this(NodeType.ELM, name);
    }

    public NodeTest(NodeType type, QNm name) {
        this(type, name, null);
    }

    public NodeTest(NodeType type, QNm name, Type ext) {
        super(type);
        this.name = name;
        this.ext = ext;
    }

    @Override
    public Test copy() {
        return new NodeTest(this.type, this.name, this.ext);
    }

    @Override
    public boolean eq(ANode node) {
        return !(this.type != node.type || this.name != null && !node.qname().eq(this.name) || this.ext != null && this.ext != AtomType.ATY && this.ext != AtomType.UTY && (this.type != NodeType.ATT || this.ext != AtomType.AST && this.ext != AtomType.AAT && this.ext != AtomType.ATM));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeTest)) {
            return false;
        }
        NodeTest nt = (NodeTest)obj;
        return this.type == nt.type && (this.name == null ? nt.name == null : nt.name != null && this.name.eq(nt.name)) && (this.ext == null ? nt.ext == null : nt.ext != null && this.ext.eq(nt.ext));
    }

    @Override
    public NodeTest intersect(Test other) {
        if (other instanceof NodeTest) {
            boolean both;
            NodeType nt;
            NodeTest o = (NodeTest)other;
            if (this.type != null && o.type != null && this.type != o.type) {
                return null;
            }
            NodeType nodeType = nt = this.type != null ? this.type : o.type;
            if (this.name != null && o.name != null && !this.name.eq(o.name)) {
                return null;
            }
            QNm n = this.name != null ? this.name : o.name;
            boolean bl = both = this.ext != null && o.ext != null;
            Type e = this.ext == null ? o.ext : (o.ext == null ? this.ext : this.ext.intersect(o.ext));
            return both && e == null ? null : new NodeTest(nt, n, e);
        }
        if (other instanceof KindTest) {
            return this.type.instanceOf(other.type) ? this : null;
        }
        if (other instanceof NameTest) {
            throw Util.notExpected(other, new Object[0]);
        }
        return null;
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (this.name == null) {
            tb.add(42);
        } else {
            tb.add(this.name.string());
        }
        if (this.ext != null) {
            tb.add(44).addExt(this.ext, new Object[0]);
        }
        return tb.toString();
    }
}

