/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.gflwor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.Expr;
import org.basex.query.expr.If;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.Count;
import org.basex.query.expr.gflwor.For;
import org.basex.query.expr.gflwor.ForLet;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.expr.gflwor.Where;
import org.basex.query.expr.gflwor.Window;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarUsage;
import org.basex.util.BitArray;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class GFLWOR
extends ParseExpr {
    public final LinkedList<Clause> clauses;
    public Expr ret;

    public GFLWOR(InputInfo info, LinkedList<Clause> clauses, Expr ret) {
        super(info, SeqType.ITEM_ZM);
        this.clauses = clauses;
        this.ret = ret;
    }

    private Eval newEval() {
        Eval eval = new StartEval();
        for (Clause clause : this.clauses) {
            eval = clause.eval(eval);
        }
        return eval;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item out = null;
        Eval eval = this.newEval();
        while (eval.next(qc)) {
            Item item = this.ret.item(qc, this.info);
            if (item == null) continue;
            if (out != null) {
                throw QueryError.SEQFOUND_X.get(this.info, ValueBuilder.concat(out, item, qc));
            }
            out = item;
        }
        return out;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Eval eval = this.newEval();
        ValueBuilder vb = new ValueBuilder(qc);
        while (eval.next(qc)) {
            vb.add(this.ret.value(qc));
        }
        return vb.value();
    }

    @Override
    public Iter iter(final QueryContext qc) {
        return new Iter(){
            private final Eval ev;
            private Iter sub;
            {
                this.ev = GFLWOR.this.newEval();
                this.sub = Empty.ITER;
            }

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = qc.next(this.sub)) == null) {
                    if (!this.ev.next(qc)) {
                        this.sub = null;
                        return null;
                    }
                    this.sub = GFLWOR.this.ret.iter(qc);
                }
                return item;
            }
        };
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        ListIterator<Clause> iter = this.clauses.listIterator();
        try {
            while (iter.hasNext()) {
                ((Clause)iter.next()).compile(cc);
            }
        }
        catch (QueryException qe) {
            iter.remove();
            this.clauseError(qe, iter, cc);
        }
        try {
            this.ret = this.ret.compile(cc);
        }
        catch (QueryException qe) {
            this.clauseError(qe, iter, cc);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        boolean changed;
        ListIterator<Where> iter = this.clauses.listIterator();
        while (iter.hasNext()) {
            Clause clause = (Clause)iter.next();
            if (!(clause instanceof Where)) continue;
            Where where = (Where)clause;
            if (!(where.expr instanceof And)) continue;
            iter.remove();
            Expr[] exprArray = ((Arr)where.expr).exprs;
            int n = ((Arr)where.expr).exprs.length;
            int n2 = 0;
            while (n2 < n) {
                Expr expr = exprArray[n2];
                iter.add(new Where(expr, where.info));
                ++n2;
            }
        }
        do {
            TypeCheck tc;
            GFLWOR sub;
            GFLWOR sub2;
            changed = this.forToLet(cc);
            changed |= this.slideLetsOut(cc);
            changed |= this.inlineLets(cc);
            changed |= this.unusedVars(cc);
            changed |= this.cleanDeadVars();
            changed |= this.unnestFLWR(cc);
            changed |= this.optimizeWhere(cc);
            changed |= this.optimizePos(cc);
            if (this.clauses.isEmpty()) {
                cc.info("simplify %", this.description());
                return this.ret;
            }
            if (this.clauses.getLast() instanceof For && this.ret instanceof VarRef) {
                For last = (For)this.clauses.getLast();
                if (!last.var.checksType() && last.var.is(((VarRef)this.ret).var)) {
                    this.clauses.removeLast();
                    this.ret = last.expr;
                    changed = true;
                }
            }
            if (!this.clauses.isEmpty() && this.clauses.getFirst() instanceof For) {
                For fst = (For)this.clauses.getFirst();
                if (!fst.empty) {
                    if (fst.expr instanceof GFLWOR) {
                        cc.info("flatten nested %: %", this.description(), fst.var);
                        sub2 = (GFLWOR)fst.expr;
                        this.clauses.set(0, new For(fst.var, null, fst.score, sub2.ret, false));
                        if (fst.pos != null) {
                            this.clauses.add(1, new Count(fst.pos));
                        }
                        this.clauses.addAll(0, sub2.clauses);
                        changed = true;
                    } else if (this.clauses.size() > 1 && this.clauses.get(1) instanceof Count) {
                        Count cnt = (Count)this.clauses.get(1);
                        if (fst.pos != null) {
                            VarRef vr = new VarRef(cnt.info, fst.pos);
                            Let lt = new Let(cnt.var, vr.optimize(cc), false);
                            this.clauses.set(1, lt.optimize(cc));
                        } else {
                            For fr = new For(fst.var, cnt.var, fst.score, fst.expr, false);
                            this.clauses.set(0, fr.optimize(cc));
                            this.clauses.remove(1);
                        }
                        changed = true;
                    }
                }
            }
            if (this.clauses.isEmpty()) continue;
            if (this.ret instanceof GFLWOR && (sub = (GFLWOR)this.ret).isFLW()) {
                Clause clause = sub.clauses.getFirst();
                Clause var = clause instanceof ForLet ? ((ForLet)clause).var : clause;
                cc.info("flatten nested %: %", this.description(), var);
                this.clauses.addAll(sub.clauses);
                this.ret = sub.ret;
                changed = true;
            }
            TypeCheck typeCheck = tc = this.ret instanceof TypeCheck ? (TypeCheck)this.ret : null;
            if (!(this.ret instanceof GFLWOR) && (tc == null || !(tc.expr instanceof GFLWOR))) continue;
            sub2 = (GFLWOR)(tc == null ? this.ret : tc.expr);
            Clause clause = sub2.clauses.getFirst();
            if (!(clause instanceof Let)) continue;
            cc.info("flatten nested %: %", this.description(), ((Let)clause).var);
            LinkedList<Clause> cls = sub2.clauses;
            do {
                this.clauses.add(cls.removeFirst());
            } while (!cls.isEmpty() && cls.getFirst() instanceof Let);
            if (tc != null) {
                tc.expr = sub2.optimize(cc);
            }
            this.ret = this.ret.optimize(cc);
            changed = true;
        } while (changed);
        this.mergeWheres();
        this.calcSize();
        long size = this.size();
        if (size != -1L && !this.has(Flag.NDT)) {
            if (size == 0L) {
                return cc.emptySeq(this);
            }
            Expr rep = null;
            if (this.ret instanceof Value) {
                rep = SingletonSeq.get((Value)this.ret, size / this.ret.size());
            } else if (!this.ret.has(Flag.CTX, Flag.POS) && !this.varsInReturn()) {
                if (size == 1L) {
                    rep = this.ret;
                } else if (!this.ret.has(Flag.NDT, Flag.CNS)) {
                    rep = cc.function(Function._UTIL_REPLICATE, this.info, this.ret, Int.get(size / this.ret.size()));
                }
            }
            if (rep != null) {
                return cc.replaceWith(this, rep);
            }
        }
        if (this.clauses.getFirst() instanceof Where) {
            Where where = (Where)this.clauses.removeFirst();
            Expr branch = this.clauses.isEmpty() ? this.ret : this;
            return cc.replaceWith(where, new If(this.info, where.expr, branch, (Expr)Empty.SEQ).optimize(cc));
        }
        return this;
    }

    private boolean varsInReturn() {
        for (Clause clause : this.clauses) {
            Var[] varArray = clause.vars();
            int n = varArray.length;
            int n2 = 0;
            while (n2 < n) {
                Var var = varArray[n2];
                if (this.ret.count(var) != VarUsage.NEVER) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void calcSize() {
        long[] minMax = new long[]{1L, 1L};
        for (Clause clause : this.clauses) {
            if (minMax[1] == 0L) continue;
            clause.calcSize(minMax);
        }
        if (minMax[1] != 0L) {
            long size = this.ret.size();
            minMax[0] = minMax[0] * Math.max(size, 0L);
            long max = minMax[1];
            if (max > 0L) {
                minMax[1] = size < 0L ? -1L : max * size;
            }
        }
        this.exprType.assign(this.ret.seqType().type, minMax);
    }

    private boolean forToLet(CompileContext cc) {
        boolean changed = false;
        int i = this.clauses.size();
        while (--i >= 0) {
            Clause clause = this.clauses.get(i);
            if (!(clause instanceof For) || !((For)clause).asLet(this.clauses, i)) continue;
            cc.info("rewrite for to let: %", clause);
            changed = true;
        }
        return changed;
    }

    private boolean unusedVars(CompileContext cc) throws QueryException {
        boolean changed = false;
        ListIterator iter = this.clauses.listIterator();
        while (iter.hasNext()) {
            int pos = iter.nextIndex();
            Clause clause = (Clause)iter.next();
            if (clause instanceof Let) {
                Let lt = (Let)clause;
                if (this.count(lt.var, pos + 1) != VarUsage.NEVER || lt.has(Flag.NDT)) continue;
                cc.info("remove variable %", lt.var);
                lt.var.checkType(lt.expr);
                iter.remove();
                changed = true;
                continue;
            }
            if (!(clause instanceof For)) continue;
            For fr = (For)clause;
            long fs = fr.expr.size();
            if (fs > 1L && fr.var.declType == null && !(fr.expr instanceof SingletonSeq) && !fr.has(Flag.NDT) && this.count(fr.var, pos + 1) == VarUsage.NEVER) {
                fr.expr = cc.replaceWith(fr.expr, SingletonSeq.get(Str.ZERO, fs));
                changed = true;
            }
            if (fr.score != null && this.count(fr.score, pos) == VarUsage.NEVER) {
                cc.info("remove variable %", fr.score);
                fr.score = null;
                changed = true;
            }
            if (fr.pos == null || this.count(fr.pos, pos) != VarUsage.NEVER) continue;
            cc.info("remove variable %", fr.pos);
            fr.pos = null;
            changed = true;
        }
        return changed;
    }

    private boolean inlineLets(CompileContext cc) throws QueryException {
        boolean changing;
        boolean changed = false;
        block0: do {
            changing = false;
            ListIterator<Clause> iter = this.clauses.listIterator();
            while (iter.hasNext()) {
                Clause clause = (Clause)iter.next();
                int next = iter.nextIndex();
                if (!(clause instanceof Let)) continue;
                Let lt = (Let)clause;
                Expr expr = lt.expr;
                if (expr.has(Flag.NDT) || !(expr instanceof Value || expr instanceof VarRef && !lt.var.checksType() || this.count(lt.var, next) == VarUsage.ONCE && !expr.has(Flag.CTX, Flag.CNS)) && (!(expr instanceof AxisPath) || !((AxisPath)expr).cheap())) continue;
                cc.info("inline %", lt.var);
                this.inline(cc, lt.var, lt.inlineExpr(cc), iter);
                this.clauses.remove(lt);
                changed = true;
                changing = true;
                continue block0;
            }
        } while (changing);
        return changed;
    }

    private boolean unnestFLWR(CompileContext cc) throws QueryException {
        boolean thisRound;
        boolean changed = false;
        do {
            thisRound = false;
            ListIterator<Clause> iter = this.clauses.listIterator();
            while (iter.hasNext()) {
                Expr rest;
                Expr expr;
                GFLWOR fl;
                Clause clause = (Clause)iter.next();
                boolean isFor = clause instanceof For;
                boolean isLet = clause instanceof Let;
                if (isFor) {
                    For fr = (For)clause;
                    if (!fr.empty && fr.pos == null && fr.expr instanceof GFLWOR && (fl = (GFLWOR)fr.expr).isFLW()) {
                        cc.info("flatten nested %: %", this.description(), fr.var);
                        iter.remove();
                        for (Clause clause2 : fl.clauses) {
                            iter.add(clause2);
                        }
                        fr.expr = fl.ret;
                        iter.add(fr);
                        changed = true;
                        thisRound = true;
                    }
                }
                if (thisRound || !isFor && !isLet) continue;
                Expr expr2 = expr = isFor ? ((For)clause).expr : ((Let)clause).expr;
                if (!(expr instanceof GFLWOR)) continue;
                fl = (GFLWOR)expr;
                LinkedList<Clause> linkedList = fl.clauses;
                if (!(linkedList.getFirst() instanceof Let)) continue;
                iter.remove();
                do {
                    iter.add(linkedList.removeFirst());
                } while (!linkedList.isEmpty() && linkedList.getFirst() instanceof Let);
                Expr expr3 = rest = fl.clauses.isEmpty() ? fl.ret : fl.optimize(cc);
                if (isFor) {
                    ((For)clause).expr = rest;
                } else {
                    ((Let)clause).expr = rest;
                }
                iter.add(clause);
                changed = true;
                thisRound = true;
            }
        } while (thisRound);
        return changed;
    }

    private boolean cleanDeadVars() {
        final IntObjMap<Var> decl = new IntObjMap<Var>();
        for (Clause clause : this.clauses) {
            Var[] varArray = clause.vars();
            int n = varArray.length;
            int n2 = 0;
            while (n2 < n) {
                Var var = varArray[n2];
                decl.put(var.id, var);
                ++n2;
            }
        }
        final BitArray used = new BitArray();
        ASTVisitor marker = new ASTVisitor(){

            @Override
            public boolean used(VarRef ref) {
                int id = ref.var.id;
                if (decl.get(id) != null) {
                    used.set(id);
                }
                return true;
            }
        };
        this.ret.accept(marker);
        boolean changed = false;
        int c = this.clauses.size();
        while (--c >= 0) {
            Clause clause = this.clauses.get(c);
            changed |= clause.clean(decl, used);
            clause.accept(marker);
            Var[] varArray = clause.vars();
            int n = varArray.length;
            int n3 = 0;
            while (n3 < n) {
                Var var = varArray[n3];
                used.clear(var.id);
                ++n3;
            }
        }
        return changed;
    }

    private boolean slideLetsOut(CompileContext cc) {
        boolean changed = false;
        int c = 1;
        while (c < this.clauses.size()) {
            Clause clause = this.clauses.get(c);
            if (clause instanceof Let && !clause.has(Flag.NDT, Flag.CNS)) {
                Let let = (Let)clause;
                int insert = -1;
                int d = c;
                while (--d >= 0) {
                    Clause curr = this.clauses.get(d);
                    if (!curr.skippable(let)) break;
                    if (!(curr instanceof For) && !(curr instanceof Window)) continue;
                    insert = d;
                }
                if (insert >= 0) {
                    cc.info("hoist let clause: %", let);
                    this.clauses.add(insert, this.clauses.remove(c));
                    changed = true;
                }
            }
            ++c;
        }
        return changed;
    }

    private boolean optimizeWhere(CompileContext cc) throws QueryException {
        boolean changed = false;
        HashSet<For> fors = new HashSet<For>();
        int i = 0;
        while (i < this.clauses.size()) {
            Clause clause = this.clauses.get(i);
            if (clause instanceof Where && !clause.has(Flag.NDT)) {
                Where where = (Where)clause;
                if (where.expr instanceof Value) {
                    boolean bool;
                    if (where.expr instanceof Bln) {
                        bool = ((Bln)where.expr).bool(this.info);
                    } else {
                        bool = where.expr.ebv(cc.qc, where.info).bool(where.info);
                        where.expr = Bln.get(bool);
                    }
                    if (!bool) break;
                    this.clauses.remove(i--);
                    changed = true;
                } else {
                    int newPos;
                    int insert = -1;
                    int j = i;
                    while (--j >= 0) {
                        Clause curr = this.clauses.get(j);
                        if (curr.has(Flag.NDT) || !curr.skippable(where)) break;
                        if (curr instanceof Where) continue;
                        insert = j;
                    }
                    if (insert >= 0) {
                        this.clauses.add(insert, this.clauses.remove(i));
                        changed = true;
                    }
                    int b4 = newPos = insert < 0 ? i : insert;
                    while (--b4 >= 0) {
                        Clause before = this.clauses.get(b4);
                        if (before instanceof For) {
                            For fr = (For)before;
                            if (!fr.toPredicate(cc, where.expr)) break;
                            fors.add((For)before);
                            this.clauses.remove(newPos);
                            --i;
                            changed = true;
                            break;
                        }
                        if (!(before instanceof Where)) break;
                    }
                }
            }
            ++i;
        }
        for (For fr : fors) {
            fr.expr = fr.expr.optimize(cc);
        }
        if (changed) {
            cc.info("rewrite where clause(s)", new Object[0]);
        }
        return changed;
    }

    private boolean optimizePos(CompileContext cc) throws QueryException {
        boolean changed = false;
        int c = 0;
        while (c < this.clauses.size()) {
            Clause clause = this.clauses.get(c);
            if (clause instanceof For) {
                For pos = (For)clause;
                if (pos.pos != null) {
                    int i = c + 1;
                    while (i < this.clauses.size()) {
                        Clause cl = this.clauses.get(i);
                        if (!(cl instanceof Where)) {
                            if (!(cl instanceof For) && !(cl instanceof Let) || cl.has(Flag.NDT)) {
                                break;
                            }
                        } else {
                            Where w = (Where)cl;
                            if (w.expr instanceof CmpR) {
                                CmpR cmp = (CmpR)w.expr;
                                if (cmp.expr instanceof VarRef) {
                                    this.clauses.remove(i);
                                    if (this.count(pos.pos, c) == VarUsage.NEVER) {
                                        pos.addPredicate(ItrPos.get(cmp));
                                        pos.expr = pos.expr.optimize(cc);
                                        cc.info("rewrite % to predicate(s)", cmp);
                                        changed = true;
                                        break;
                                    }
                                    this.clauses.add(i, cl);
                                    break;
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
            ++c;
        }
        return changed;
    }

    private void mergeWheres() {
        Where before = null;
        Iterator iter = this.clauses.iterator();
        while (iter.hasNext()) {
            Clause clause = (Clause)iter.next();
            if (clause instanceof Where) {
                Where wh = (Where)clause;
                if (wh.expr == Bln.FALSE) {
                    return;
                }
                if (before != null) {
                    iter.remove();
                    Expr expr = before.expr;
                    if (expr instanceof And) {
                        And and = (And)expr;
                        and.exprs = ExprList.concat(and.exprs, wh.expr);
                        continue;
                    }
                    before.expr = new And(before.info, expr, wh.expr);
                    continue;
                }
                before = wh;
                continue;
            }
            before = null;
        }
    }

    @Override
    public boolean isVacuous() {
        return this.ret.isVacuous();
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Clause clause : this.clauses) {
            if (!clause.has(flags)) continue;
            return true;
        }
        return this.ret.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        for (Clause clause : this.clauses) {
            if (clause.removable(var)) continue;
            return false;
        }
        return this.ret.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.count(var, 0);
    }

    private VarUsage count(Var var, int index) {
        long[] minMax = new long[]{1L, 1L};
        VarUsage uses = VarUsage.NEVER;
        ListIterator<Clause> iter = this.clauses.listIterator(index);
        while (iter.hasNext()) {
            Clause clause = iter.next();
            uses = uses.plus(clause.count(var).times(minMax[1]));
            clause.calcSize(minMax);
        }
        return uses.plus(this.ret.count(var).times(minMax[1]));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        return this.inline(cc, var, ex, this.clauses.listIterator()) ? this.optimize(cc) : null;
    }

    private boolean inline(CompileContext cc, Var var, Expr ex, ListIterator<Clause> iter) throws QueryException {
        boolean changed = false;
        while (iter.hasNext()) {
            Clause clause = iter.next();
            try {
                Clause cl = clause.inline(var, ex, cc);
                if (cl == null) continue;
                changed = true;
                iter.set(cl);
            }
            catch (QueryException qe) {
                iter.remove();
                return this.clauseError(qe, iter, cc);
            }
        }
        try {
            Expr rt = this.ret.inline(var, ex, cc);
            if (rt != null) {
                changed = true;
                this.ret = rt;
            }
        }
        catch (QueryException qe) {
            return this.clauseError(qe, iter, cc);
        }
        return changed;
    }

    private boolean clauseError(QueryException qe, ListIterator<Clause> iter, CompileContext cc) throws QueryException {
        while (iter.hasPrevious()) {
            Clause b4 = iter.previous();
            if (!(b4 instanceof For) && !(b4 instanceof Window) && !(b4 instanceof Where)) continue;
            iter.next();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
            this.ret = cc.error(qe, this.ret);
            return true;
        }
        throw qe;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        LinkedList<Clause> cls = new LinkedList<Clause>();
        for (Clause clause : this.clauses) {
            cls.add((Clause)clause.copy(cc, (IntObjMap)vm));
        }
        return this.copyType(new GFLWOR(this.info, cls, this.ret.copy(cc, vm)));
    }

    private boolean isFLW() {
        for (Clause clause : this.clauses) {
            if (clause instanceof For || clause instanceof Let || clause instanceof Where) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Clause clause : this.clauses) {
            if (clause.accept(visitor)) continue;
            return false;
        }
        return this.ret.accept(visitor);
    }

    @Override
    public void checkUp() throws QueryException {
        for (Clause clause : this.clauses) {
            clause.checkUp();
        }
        this.ret.checkUp();
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        long[] minMax = new long[]{1L, 1L};
        for (Clause clause : this.clauses) {
            clause.calcSize(minMax);
            if (minMax[1] >= 0L && minMax[1] <= 1L) continue;
            return;
        }
        this.ret.markTailCalls(cc);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Clause clause : this.clauses) {
            size += clause.exprSize();
        }
        return this.ret.exprSize() + size;
    }

    @Override
    public Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        if (tc.seqType().occ != Occ.ZERO_MORE) {
            return null;
        }
        this.ret = tc.check(this.ret, cc);
        return this.optimize(cc);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GFLWOR)) {
            return false;
        }
        GFLWOR g = (GFLWOR)obj;
        return this.clauses.equals(g.clauses) && this.ret.equals(g.ret);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem(new Object[0]);
        for (Clause clause : this.clauses) {
            clause.plan(elem);
        }
        this.ret.plan(elem);
        plan.add(elem);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Clause clause : this.clauses) {
            sb.append(clause).append(' ');
        }
        return sb.append("return").append(' ').append(this.ret).toString();
    }

    static abstract class Eval {
        Eval() {
        }

        abstract boolean next(QueryContext var1) throws QueryException;
    }

    private static final class StartEval
    extends Eval {
        private boolean first = true;

        private StartEval() {
        }

        @Override
        public boolean next(QueryContext q) {
            if (!this.first) {
                return false;
            }
            this.first = false;
            return true;
        }
    }
}

