/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.iter.FTIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexInfo;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class FTWeight
extends FTExpr {
    private Expr weight;

    public FTWeight(InputInfo info, FTExpr expr, Expr weight) {
        super(info, expr);
        this.weight = weight;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.weight);
        super.checkUp();
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        this.weight = this.weight.compile(cc);
        return super.compile(cc);
    }

    @Override
    public FTNode item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.weight(this.exprs[0].item(qc, this.info), qc);
    }

    @Override
    public FTIter iter(final QueryContext qc) {
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                return FTWeight.this.weight(FTWeight.this.exprs[0].iter(qc).next(), qc);
            }
        };
    }

    private FTNode weight(FTNode item, QueryContext qc) throws QueryException {
        if (item == null) {
            return null;
        }
        double d = this.toDouble(this.weight, qc);
        if (Math.abs(d) > 1000.0) {
            throw QueryError.FTWEIGHT_X.get(this.info, d);
        }
        if (d == 0.0) {
            item.matches().reset();
        }
        item.score(item.score() * d);
        return item;
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) {
        return false;
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.weight.has(flags) || super.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        return this.weight.removable(var) && super.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.weight.count(var).plus(super.count(var));
    }

    @Override
    public FTExpr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = FTWeight.inlineAll(this.exprs, var, ex, cc);
        Expr w = this.weight.inline(var, ex, cc);
        if (w != null) {
            this.weight = w;
            changed = true;
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new FTWeight(this.info, (FTExpr)this.exprs[0].copy(cc, (IntObjMap)vm), this.weight.copy(cc, vm));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && this.weight.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = 1;
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            size += expr.exprSize();
            ++n2;
        }
        return size + this.weight.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FTWeight && this.weight.equals(((FTWeight)obj).weight) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        FTWeight.addPlan(plan, this.planElem(new Object[0]), this.weight, this.exprs[0]);
    }

    @Override
    public String toString() {
        return this.exprs[0] + " " + "weight" + " {" + this.weight + "} ";
    }
}

