/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTAnd;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTNot;
import org.basex.query.iter.FTIter;
import org.basex.query.util.IndexCosts;
import org.basex.query.util.IndexInfo;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class FTOr
extends FTExpr {
    public FTOr(InputInfo info, FTExpr[] exprs) {
        super(info, exprs);
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        super.compile(cc);
        boolean not = true;
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            not &= expr instanceof FTNot;
            ++n2;
        }
        if (not) {
            int es = this.exprs.length;
            int e = 0;
            while (e < es) {
                this.exprs[e] = this.exprs[e].exprs[0];
                ++e;
            }
            return (FTExpr)cc.replaceWith(this, new FTNot(this.info, (FTExpr)new FTAnd(this.info, this.exprs)));
        }
        return this;
    }

    @Override
    public FTNode item(QueryContext qc, InputInfo ii) throws QueryException {
        FTNode item = this.exprs[0].item(qc, this.info);
        int es = this.exprs.length;
        int e = 1;
        while (e < es) {
            FTOr.or(item, this.exprs[e].item(qc, this.info));
            ++e;
        }
        return item;
    }

    @Override
    public FTIter iter(QueryContext qc) throws QueryException {
        final int es = this.exprs.length;
        final FTIter[] ters = new FTIter[es];
        final FTNode[] nodes = new FTNode[es];
        int e = 0;
        while (e < es) {
            ters[e] = this.exprs[e].iter(qc);
            nodes[e] = ters[e].next();
            ++e;
        }
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                int p = -1;
                int i = 0;
                while (i < es) {
                    if (nodes[i] != null && (p == -1 || nodes[p].pre() > nodes[i].pre())) {
                        p = i;
                    }
                    ++i;
                }
                if (p == -1) {
                    return null;
                }
                FTNode item = nodes[p];
                int i2 = 0;
                while (i2 < es) {
                    if (nodes[i2] != null && p != i2 && item.pre() == nodes[i2].pre()) {
                        FTOr.or(item, nodes[i2]);
                        nodes[i2] = ters[i2].next();
                    }
                    ++i2;
                }
                nodes[p] = ters[p].next();
                return item;
            }
        };
    }

    private static void or(FTNode i1, FTNode i2) {
        FTMatches all1 = i1.matches();
        FTMatches all2 = i2.matches();
        FTMatches all = new FTMatches((byte)Math.max(all1.pos, all2.pos));
        for (FTMatch m : all1) {
            all.add(m);
        }
        for (FTMatch m : all2) {
            all.add(m);
        }
        i1.score(Scoring.avg(i1.score() + i2.score(), 2));
        i1.matches(all);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexCosts costs = IndexCosts.ZERO;
        FTExpr[] fTExprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            FTExpr expr = fTExprArray[n2];
            if (!expr.indexAccessible(ii)) {
                return false;
            }
            costs = IndexCosts.add(costs, ii.costs);
            ++n2;
        }
        ii.costs = costs;
        return true;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new FTOr(this.info, (FTExpr[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FTOr && super.equals(obj);
    }

    @Override
    public String toString() {
        return "(" + this.toString(" ftor ") + ")";
    }
}

