/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Simple;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTWords;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.func.Function;
import org.basex.query.iter.FTIter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTMode;
import org.basex.util.hash.IntObjMap;

public final class FTIndexAccess
extends Simple {
    private IndexDb db;
    private FTExpr ftexpr;

    public FTIndexAccess(InputInfo info, FTExpr ftexpr, IndexDb db) {
        super(info, SeqType.TXT_ZM);
        this.ftexpr = ftexpr;
        this.db = db;
    }

    @Override
    public NodeIter iter(final QueryContext qc) throws QueryException {
        final FTIter iter = this.ftexpr.iter(qc);
        return new NodeIter(){

            @Override
            public ANode next() throws QueryException {
                FTNode it = iter.next();
                if (it != null) {
                    if (qc.scoring) {
                        it.score();
                    }
                    if (qc.ftPosData != null) {
                        qc.ftPosData.add(it.data(), it.pre(), it.matches());
                    }
                    it.matches(null);
                }
                return it;
            }
        };
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.ftexpr.has(flags) || this.db.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        return this.ftexpr.removable(var) && this.db.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.ftexpr.count(var).plus(this.db.count(var));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        IndexDb sub;
        FTExpr fte = this.ftexpr.inline(var, ex, cc);
        if (fte != null) {
            this.ftexpr = fte;
        }
        if ((sub = this.db.inline(var, ex, cc)) != null) {
            this.db = sub;
        }
        return fte != null || sub != null ? this.optimize(cc) : this;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new FTIndexAccess(this.info, (FTExpr)this.ftexpr.copy(cc, (IntObjMap)vm), (IndexDb)this.db.copy(cc, (IntObjMap)vm));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.ftexpr.accept(visitor) && this.db.accept(visitor);
    }

    @Override
    public boolean iterable() {
        return this.seqType().zeroOrOne() || this.db.iterable();
    }

    @Override
    public int exprSize() {
        return this.ftexpr.exprSize() + this.db.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FTIndexAccess)) {
            return false;
        }
        FTIndexAccess f = (FTIndexAccess)obj;
        return this.ftexpr.equals(f.ftexpr) && this.db.equals(f.db);
    }

    @Override
    public void plan(FElem plan) {
        FTIndexAccess.addPlan(plan, this.planElem(new Object[0]), this.db, this.ftexpr);
    }

    @Override
    public String toString() {
        Expr expr = this.ftexpr;
        if (this.ftexpr instanceof FTWords) {
            FTWords ftw = (FTWords)this.ftexpr;
            if (ftw.mode == FTMode.ANY && ftw.occ == null && ftw.simple) {
                expr = ftw.query;
            }
        }
        return Function._FT_SEARCH.args(this.db.source(), expr).substring(1);
    }
}

