/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class SwitchGroup
extends Arr {
    public SwitchGroup(InputInfo info, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
    }

    @Override
    public void checkUp() throws QueryException {
        int es = this.exprs.length;
        int e = 1;
        while (e < es) {
            this.checkNoUp(this.exprs[e]);
            ++e;
        }
    }

    @Override
    public Expr compile(CompileContext cc) {
        int es = this.exprs.length;
        int e = 0;
        while (e < es) {
            try {
                this.exprs[e] = this.exprs[e].compile(cc);
            }
            catch (QueryException ex) {
                this.exprs[e] = cc.error(ex, this.exprs[e]);
            }
            ++e;
        }
        return this;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new SwitchGroup(this.info, SwitchGroup.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = false;
        int es = this.exprs.length;
        int e = 0;
        while (e < es) {
            Expr nw;
            try {
                nw = this.exprs[e].inline(var, ex, cc);
            }
            catch (QueryException qe) {
                nw = cc.error(qe, this.exprs[e]);
            }
            if (nw != null) {
                this.exprs[e] = nw;
                changed = true;
            }
            ++e;
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public VarUsage count(Var var) {
        return this.exprs[0].count(var);
    }

    VarUsage countCases(Var var) {
        VarUsage all = VarUsage.NEVER;
        int es = this.exprs.length;
        int e = 1;
        while (e < es) {
            if ((all = all.plus(this.exprs[e].count(var))) == VarUsage.MORE_THAN_ONCE) break;
            ++e;
        }
        return all;
    }

    @Override
    public int exprSize() {
        int size = 0;
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            size += expr.exprSize();
            ++n2;
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SwitchGroup && super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int es = this.exprs.length;
        int e = 1;
        while (e < es) {
            sb.append(' ').append("case").append(' ').append(this.exprs[e]);
            ++e;
        }
        if (es == 1) {
            sb.append(' ').append("default");
        }
        return sb.append(' ').append("return").append(' ').append(this.exprs[0]).toString();
    }
}

