/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.CachedMap;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ItemMap;
import org.basex.query.expr.IterMap;
import org.basex.query.func.Function;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;

public abstract class SimpleMap
extends Arr {
    SimpleMap(InputInfo info, Expr ... exprs) {
        super(info, SeqType.ITEM_ZM, exprs);
    }

    public static Expr get(InputInfo info, Expr ... exprs) {
        if (exprs.length == 1) {
            return exprs[0];
        }
        Expr[] exprArray = exprs;
        int n = exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            if (expr.has(Flag.POS)) {
                return new CachedMap(info, exprs);
            }
            ++n2;
        }
        return new IterMap(info, exprs);
    }

    @Override
    public final void checkUp() throws QueryException {
        int el = this.exprs.length;
        int e = 0;
        while (e < el - 1) {
            this.checkNoUp(this.exprs[e]);
            ++e;
        }
        this.exprs[el - 1].checkUp();
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        int e = 0;
        while (e < el) {
            Expr expr = this.exprs[e];
            try {
                expr = expr.compile(cc);
            }
            catch (QueryException qe) {
                expr = cc.error(qe, this);
            }
            if (e == 0) {
                cc.pushFocus(expr);
            } else {
                cc.updateFocus(expr);
            }
            this.exprs[e] = expr;
            ++e;
        }
        cc.removeFocus();
        return this.optimize(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        ExprList list = new ExprList(this.exprs.length);
        long min = 1L;
        long max = 1L;
        boolean it = true;
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            if (max == 0L) break;
            list.add(expr);
            long es = expr.size();
            if (es == 0L) {
                min = 0L;
                max = 0L;
            } else if (es > 0L) {
                min *= es;
                if (max != -1L) {
                    max *= es;
                }
                if (es > 1L) {
                    it = false;
                }
            } else {
                Occ o = expr.seqType().occ;
                if (o.min == 0) {
                    min = 0L;
                }
                if (o.max > 1) {
                    max = -1L;
                    it = false;
                }
            }
            ++n2;
        }
        if (this.exprs.length != list.size()) {
            cc.info("simplify %", this);
            this.exprs = (Expr[])list.finish();
        }
        this.exprType.assign(this.exprs[this.exprs.length - 1].seqType().type, new long[]{min, max});
        int e = 0;
        int el = this.exprs.length;
        int n3 = 1;
        while (n3 < el) {
            Expr expr = this.exprs[e];
            Expr next = this.exprs[n3];
            long es = expr.size();
            Expr rep = null;
            if (es != -1L && !expr.has(Flag.NDT)) {
                if (next instanceof Value) {
                    rep = SingletonSeq.get((Value)next, es);
                } else if (!next.has(Flag.CTX, Flag.POS)) {
                    if (es == 1L) {
                        rep = next;
                    } else if (!next.has(Flag.NDT, Flag.CNS)) {
                        rep = cc.function(Function._UTIL_REPLICATE, this.info, next, Int.get(es));
                    }
                }
            }
            if (rep != null) {
                this.exprs[e] = cc.replaceWith(expr, rep);
            } else if (!(next instanceof ContextValue)) {
                this.exprs[++e] = this.exprs[n3];
            }
            ++n3;
        }
        if (++e != el) {
            this.exprs = Arrays.copyOf(this.exprs, e);
        }
        return e == 1 ? this.exprs[0] : (this.size() == 0L && !this.has(Flag.NDT) ? cc.emptySeq(this) : (it ? this.copyType(new ItemMap(this.info, this.exprs)) : this));
    }

    @Override
    public final boolean has(Flag ... flags) {
        if (Flag.CTX.in(flags) && this.exprs[0].has(Flag.CTX)) {
            return true;
        }
        if (Flag.POS.in(flags) && this.exprs[0].has(Flag.POS)) {
            return true;
        }
        Flag[] flgs = Flag.POS.remove(Flag.CTX.remove(flags));
        return flgs.length != 0 && super.has(flgs);
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        visitor.enterFocus();
        if (!SimpleMap.visitAll(visitor, this.exprs)) {
            return false;
        }
        visitor.exitFocus();
        return true;
    }

    @Override
    public final VarUsage count(Var var) {
        VarUsage all = VarUsage.NEVER;
        int el = this.exprs.length;
        int e = 1;
        while (e < el) {
            if ((all = all.plus(this.exprs[e].count(var))) == VarUsage.MORE_THAN_ONCE) break;
            ++e;
        }
        return all == VarUsage.NEVER ? this.exprs[0].count(var) : VarUsage.MORE_THAN_ONCE;
    }

    @Override
    public final boolean removable(Var var) {
        if (!this.exprs[0].removable(var)) {
            return false;
        }
        int el = this.exprs.length;
        int e = 1;
        while (e < el) {
            if (this.exprs[e].uses(var)) {
                return false;
            }
            ++e;
        }
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SimpleMap && super.equals(obj);
    }

    @Override
    public String description() {
        return "map operator";
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder().append('(');
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            if (sb.length() != 1) {
                sb.append(" ! ");
            }
            sb.append(expr);
            ++n2;
        }
        return sb.append(')').toString();
    }
}

