/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.function.Function;
import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Or;
import org.basex.query.func.fn.FnBoolean;
import org.basex.query.func.fn.FnNot;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;

abstract class Logical
extends Arr {
    Logical(InputInfo info, Expr[] exprs) {
        super(info, SeqType.BLN_O, exprs);
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        int e = 0;
        while (e < el) {
            try {
                this.exprs[e] = this.exprs[e].compile(cc);
            }
            catch (QueryException qe) {
                if (e == 0) {
                    throw qe;
                }
                this.exprs[e] = cc.error(qe, this.exprs[e]);
            }
            ++e;
        }
        return this.optimize(cc);
    }

    public final Expr optimize(CompileContext cc, boolean and, Function<Expr[], Logical> negate) throws QueryException {
        Expr expr;
        ExprList list = new ExprList(this.exprs.length);
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            expr = exprArray[n2];
            Expr ex = expr.optimizeEbv(cc);
            if (and ? ex instanceof And : ex instanceof Or) {
                Expr[] exprArray2 = ((Logical)ex).exprs;
                int n3 = ((Logical)ex).exprs.length;
                int n4 = 0;
                while (n4 < n3) {
                    Expr exp = exprArray2[n4];
                    list.add(exp);
                    ++n4;
                }
                cc.info("flatten nested %: %", this.description(), ex);
            } else if (ex instanceof Value) {
                cc.info("remove % from %", expr, this.description());
                if (ex.ebv(cc.qc, this.info).bool(this.info) ^ and) {
                    return Bln.get(!and);
                }
            } else {
                list.add(ex);
            }
            ++n2;
        }
        if (list.isEmpty()) {
            return Bln.get(and);
        }
        this.exprs = (Expr[])list.finish();
        list = new ExprList(this.exprs.length);
        this.simplify(cc, list);
        if (list.size() == 1) {
            return cc.replaceWith(this, FnBoolean.get((Expr)list.get(0), this.info, cc.sc()));
        }
        exprArray = this.exprs = (Expr[])list.finish();
        n = this.exprs.length;
        n2 = 0;
        while (n2 < n) {
            expr = exprArray[n2];
            if (!expr.isFunction(org.basex.query.func.Function.NOT)) {
                return this;
            }
            ++n2;
        }
        list = new ExprList(this.exprs.length);
        exprArray = this.exprs;
        n = this.exprs.length;
        n2 = 0;
        while (n2 < n) {
            expr = exprArray[n2];
            list.add(((FnNot)expr).exprs[0]);
            ++n2;
        }
        this.exprs = (Expr[])list.finish();
        expr = negate.apply(this.exprs).optimize(cc);
        return cc.replaceWith(this, cc.function(org.basex.query.func.Function.NOT, this.info, expr));
    }

    abstract void simplify(CompileContext var1, ExprList var2) throws QueryException;

    @Override
    public final void markTailCalls(CompileContext cc) {
        Expr last = this.exprs[this.exprs.length - 1];
        if (last.seqType().eq(SeqType.BLN_O)) {
            last.markTailCalls(cc);
        }
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = false;
        int el = this.exprs.length;
        int e = 0;
        while (e < el) {
            block4: {
                try {
                    Expr exp = this.exprs[e].inline(var, ex, cc);
                    if (exp == null) break block4;
                    this.exprs[e] = exp;
                    changed = true;
                }
                catch (QueryException qe) {
                    if (e == 0) {
                        throw qe;
                    }
                    Expr[] nw = new Expr[e + 1];
                    System.arraycopy(this.exprs, 0, nw, 0, e);
                    nw[e] = cc.error(qe, this);
                    this.exprs = nw;
                    changed = true;
                    break;
                }
            }
            ++e;
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem(new Object[0]);
        plan.add(elem);
        Expr[] exprArray = this.exprs;
        int n = this.exprs.length;
        int n2 = 0;
        while (n2 < n) {
            Expr expr = exprArray[n2];
            expr.plan(elem);
            ++n2;
        }
    }
}

