/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.value.item.Bln;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Instance
extends Single {
    private final SeqType instType;

    public Instance(InputInfo info, Expr expr, SeqType instType) {
        super(info, expr, SeqType.BLN_O);
        this.instType = instType;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        return this.expr.seqType().instanceOf(this.instType) ? cc.replaceWith(this, Bln.TRUE) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.instType.instance(this.expr.value(qc)));
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new Instance(this.info, this.expr.copy(cc, vm), this.instType);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Instance && this.instType.eq(((Instance)obj).instType) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        Instance.addPlan(plan, this.planElem("of", this.instType), this.expr);
    }

    @Override
    public String toString() {
        return Util.info("% instance of %", this.expr, this.instType);
    }
}

